<?php
require 'vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\IOFactory;

$min = 10;
$max = 30;

$excelFile = __DIR__ . "/leads.xlsx";
$inboxCsv  = __DIR__ . "/inbox/tool_export.csv";

/* Load or create Excel */
if (file_exists($excelFile)) {
    $spreadsheet = IOFactory::load($excelFile);
    $sheet = $spreadsheet->getActiveSheet();
    $rowNum = $sheet->getHighestRow() + 1;
} else {
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->fromArray(
        ['Keyword','Post URL','Post Date','Captured Time'],
        NULL,
        'A1'
    );
    $rowNum = 2;
}

$writer = new Xlsx($spreadsheet);

/* Count existing leads */
$found = $rowNum - 2;

while (true) {

    // ⏸ Pause support
    if (file_exists("pause.txt")) {
        sleep(5);
        continue;
    }

    if (!file_exists($inboxCsv)) {
        sleep(5);
        continue;
    }

    $rows = array_map('str_getcsv', file($inboxCsv));
    unset($rows[0]); // remove header

    foreach ($rows as $r) {

        if ($found >= $max) {
            $writer->save($excelFile);
            exit("Max limit reached safely");
        }

        $url  = trim($r[0]);
        $date = trim($r[1]);

        // 7 days filter
        if (strtotime($date) < strtotime("-7 days")) {
            continue;
        }

        // duplicate check
        $allData = $sheet->toArray();
        $exists = false;
        foreach ($allData as $d) {
            if (isset($d[1]) && $d[1] === $url) {
                $exists = true;
                break;
            }
        }
        if ($exists) continue;

        // write row
        $sheet->setCellValue("A{$rowNum}", "auto");
        $sheet->setCellValue("B{$rowNum}", $url);
        $sheet->setCellValue("C{$rowNum}", $date);
        $sheet->setCellValue("D{$rowNum}", date("H:i:s"));

        $rowNum++;
        $found++;

        $writer->save($excelFile);

        // human delay
        sleep(rand(15,30));
    }

    if ($found >= $min) {
        sleep(60); // cool down
    }

    sleep(10);
}
