<?php
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if ($data && isset($data['vm_id'])) {
    $vm_id = $data['vm_id'];
    $unit  = $data['unit_id'] ?? '';
    $group = $data['group_name'] ?? '';
    $rdp   = $data['rdp_nickname'] ?? '';
    $bal   = $data['balance'] ?? '0';
    $traf  = $data['traffic'] ?? '0';
    $stat  = $data['status'] ?? 'Offline';
    $token = $data['earnapp_token'] ?? null;
    $ip    = $data['ip_address'] ?? $_SERVER['REMOTE_ADDR'];

    // 1. UPDATE MAIN TABLE (Latest Status)
    $sql = "INSERT INTO earnapp_nodes (vm_id, unit_id, group_name, rdp_nickname, balance, traffic, status, ip_address, earnapp_token, last_heartbeat) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, NOW()) 
            ON DUPLICATE KEY UPDATE 
            balance = VALUES(balance), 
            traffic = VALUES(traffic), 
            status = VALUES(status), 
            ip_address = VALUES(ip_address),
            earnapp_token = VALUES(earnapp_token),
            last_heartbeat = NOW()";

    $stmt = $conn->prepare($sql);
    $stmt->bind_param("sssssssss", $vm_id, $unit, $group, $rdp, $bal, $traf, $stat, $ip, $token);
    $stmt->execute();
    $stmt->close();
 
    $sql_hist = "
        INSERT INTO earnapp_history (vm_id, group_name, rdp_nickname, balance, traffic, ip_address, earnapp_token)
        SELECT ?,?,?,?,?,?,?
        FROM DUAL
        WHERE NOT EXISTS (
            SELECT 1 FROM earnapp_history
            WHERE vm_id = ?
            AND DATE(recorded_at) = CURDATE()
        )
        ";
    
    $stmt_hist = $conn->prepare($sql_hist);
    $stmt_hist->bind_param("sssssss", $vm_id, $group, $rdp, $bal, $traf, $ip, $token);
    
    if ($stmt_hist->execute()) {
        echo json_encode(["status" => "Success", "history" => "Saved"]);
    } else {
        echo json_encode(["status" => "Error", "msg" => $conn->error]);
    }
    $stmt_hist->close();
}
$conn->close();
?>