<?php
require_once 'db.php';

if (isset($_POST['delete_ids'])) {
    $ids_to_delete = $_POST['delete_ids'];
    if (!empty($ids_to_delete)) {
        $ids_string = implode(',', array_map('intval', $ids_to_delete));
        $conn->query("DELETE FROM earnapp_history WHERE id IN ($ids_string)");
        echo "<script>window.location.href='?page=earnings';</script>";
    }
}

$sql = "SELECT id, vm_id, group_name, rdp_nickname, balance, traffic, ip_address, earnapp_token, recorded_at 
        FROM earnapp_history ORDER BY vm_id, recorded_at DESC";
$result = $conn->query($sql);

$vms = [];
while($row = $result->fetch_assoc()) {
    $key = $row['vm_id'].'_'.$row['rdp_nickname'];
    $vms[$key]['name'] = $row['rdp_nickname'];
    $vms[$key]['rows'][] = $row;
}
?>

<div class="container-fluid px-4 py-3">
    <form id="bulkForm" method="POST">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="h3">Earnings History (VM Wise)</h2>
            <div>
                <button type="button" class="btn btn-danger btn-sm" onclick="confirmDelete()">
                    <i class="fas fa-trash"></i> Delete Selected
                </button>
                <button type="button" class="btn btn-primary btn-sm" onclick="location.reload()">Refresh</button>
            </div>
        </div>

        <div class="accordion" id="vmAccordion">
            <?php 
            $count = 0;
            foreach ($vms as $vm):
    $rdp_name = $vm['name'];
    $history  = $vm['rows'];
                $count++;
                $accordionId = "collapse" . $count;
            ?>
            <div class="accordion-item mb-3 border shadow-sm">
                <h2 class="accordion-header">
                    <button class="accordion-button collapsed bg-light text-dark" type="button" data-bs-toggle="collapse" data-bs-target="#<?php echo $accordionId; ?>">
                        <div class="d-flex justify-content-between w-100 align-items-center">
                            <span><i class="fas fa-desktop me-2 text-primary"></i> <strong><?php echo htmlspecialchars($rdp_name); ?></strong></span>
                            <span class="badge bg-secondary me-3"><?php echo count($history); ?> Records</span>
                        </div>
                    </button>
                </h2>
                <div id="<?php echo $accordionId; ?>" class="accordion-collapse collapse" data-bs-parent="#vmAccordion">
                    <div class="accordion-body p-0">
                        <div class="table-responsive">
                            <table class="table table-sm table-hover mb-0">
                                <thead class="table-dark">
                                    <tr>
                                        <th width="40" class="ps-3"><input type="checkbox" onclick="selectVMRows(this, '<?php echo $accordionId; ?>')"></th>
                                        <th>Time</th>
                                        <th>Balance</th>
                                        <th>Traffic</th>
                                        <th>IP & VMID</th>
                                        <th>Token</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php 
                                    $last_date = "";
                                    foreach($history as $row): 
                                        $current_date = date('F d, Y', strtotime($row['recorded_at']));
                                        if ($current_date != $last_date):
                                            $last_date = $current_date;
                                    ?>
                                        <tr class="table-secondary">
                                            <td colspan="6" class="fw-bold small py-1 ps-3">
                                                <i class="far fa-calendar-alt me-1"></i> <?php echo $current_date; ?>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                        <tr>
                                            <td class="ps-3"><input type="checkbox" name="delete_ids[]" value="<?php echo $row['id']; ?>" class="rowCheckbox"></td>
                                            <td class="small"><?php echo date('H:i:s', strtotime($row['recorded_at'])); ?></td>
                                            <td class="text-success fw-bold"><?php echo htmlspecialchars($row['balance']); ?></td>
                                            <td><?php echo htmlspecialchars($row['traffic']); ?></td>
                                            <td class="small text-muted">
                                                IP: <?php echo htmlspecialchars($row['ip_address']); ?> | ID: <?php echo htmlspecialchars($row['vm_id']); ?>
                                            </td>
                                            <td>
                                                <div class="input-group input-group-sm" style="width: 140px;">
                                                    <input type="text" class="form-control" value="<?php echo htmlspecialchars($row['earnapp_token']); ?>" id="tkn_<?php echo $row['id']; ?>" readonly>
                                                    <button class="btn btn-outline-secondary" type="button" onclick="copyToken('tkn_<?php echo $row['id']; ?>')">
                                                        <i class="fas fa-copy"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>

            <?php if(empty($vms)): ?>
                <div class="alert alert-info text-center">No data available.</div>
            <?php endif; ?>
        </div>
    </form>
</div>

<script>
function selectVMRows(source, accordionId) {
    var container = document.getElementById(accordionId);
    var checkboxes = container.getElementsByClassName('rowCheckbox');
    for(var i=0; i<checkboxes.length; i++) {
        checkboxes[i].checked = source.checked;
    }
}

function copyToken(id) {
    var copyText = document.getElementById(id);
    copyText.select();
    navigator.clipboard.writeText(copyText.value);
    alert("Token Copied!");
}

function confirmDelete() {
    var checkedCount = document.querySelectorAll('.rowCheckbox:checked').length;
    if (checkedCount === 0) {
        alert("Pehle rows select karein!");
        return;
    }
    if (confirm("Kya aap " + checkedCount + " records delete karna chahte hain?")) {
        document.getElementById('bulkForm').submit();
    }
}
</script>