<?php
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';


$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || empty($data['vm_id'])) {
    echo json_encode(["status" => "error", "msg" => "vm_id missing"]);
    exit;
}

$vmId  = (int)$data['vm_id'];
$group = trim($data['group_name'] ?? '');
$rdp   = trim($data['rdp_nickname'] ?? '');
$bal   = $data['balance'] ?? null;
$trafRaw = $data['traffic'] ?? '0';
$traf = (float)preg_replace('/[^0-9.]/', '', $trafRaw);
$stat = ucfirst(strtolower($data['status'] ?? 'Offline'));
$rawStatus = strtolower($data['status'] ?? '');

if (strpos($rawStatus, 'sharing resources blocked') !== false) {
    $stat = 'Blocked';
} elseif (strpos($rawStatus, 'resource sharing') !== false) {
    $stat = 'Running';
} elseif (strpos($rawStatus, 'unknown') !== false) {
    $stat = 'Unknown';
}

$token = $data['earnapp_token'] ?? null;
$ip    = $data['ip_address'] ?? $_SERVER['REMOTE_ADDR'];

$isHeartbeat = isset($data['action']) && $data['action'] === 'heartbeat';

/* 1. VERIFY VM EXISTS */
$chk = $conn->prepare("SELECT id FROM vms WHERE id = ? LIMIT 1");
$chk->bind_param("i", $vmId);
$chk->execute();
$chk->store_result();

if ($chk->num_rows === 0) {
    echo json_encode(["status" => "error", "msg" => "VM not registered"]);
    exit;
}
$chk->close();

/* 2. HEARTBEAT ONLY */
if ($isHeartbeat) {
    $sql = "
        UPDATE vms SET
            current_ip = ?,
            last_heartbeat = NOW()
        WHERE id = ?
    ";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("si", $ip, $vmId);

} else {

    /* 3. RESOLVE GROUP ID */
    $groupId = null;
    $qg = $conn->prepare("SELECT id FROM groups WHERE name = ? LIMIT 1");
    $qg->bind_param("s", $group);
    $qg->execute();
    $qg->bind_result($groupId);
    $qg->fetch();
    $qg->close();

    if (!$groupId) {
        echo json_encode(["status" => "error", "msg" => "Invalid group"]);
        exit;
    }

    /* 4. RESOLVE RDP ID */
    $rdpId = null;
    $qr = $conn->prepare("
        SELECT id FROM rdps 
        WHERE name = ? AND group_id = ?
        LIMIT 1
    ");
    $qr->bind_param("si", $rdp, $groupId);
    $qr->execute();
    $qr->bind_result($rdpId);
    $qr->fetch();
    $qr->close();

    if (!$rdpId) {
        echo json_encode(["status" => "error", "msg" => "Invalid RDP for group"]);
        exit;
    }

    if ($bal !== null && $bal !== '') {
        $sql = "
            UPDATE vms SET
                balance = ?,
                traffic = ?,
                status = ?,
                earnapp_token = ?,
                current_ip = ?,
                last_heartbeat = NOW()
            WHERE id = ?
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param(
            "ddsssi",
            $bal,
            $traf,
            $stat,
            $token,
            $ip,
            $vmId
        );
    } else {
        $sql = "
            UPDATE vms SET
                traffic = ?,
                status = ?,
                earnapp_token = ?,
                current_ip = ?,
                last_heartbeat = NOW()
            WHERE id = ?
        ";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param(
            "ssssi",
            $traf,
            $stat,
            $token,
            $ip,
            $vmId
        );
    }
}

if ($stmt->execute()) {
    echo json_encode(["status" => "success"]);
} else {
    echo json_encode(["status" => "error", "msg" => $stmt->error]);
}

$stmt->close();
$conn->close();
