<?php
require_once 'db.php';

function timeAgo($timestamp) {
    if (!$timestamp || $timestamp == '0000-00-00 00:00:00') return "Never";
    $time = strtotime($timestamp);
    $diff = time() - $time;
    if ($diff < 60) return "Just now";
    if ($diff < 3600) return round($diff / 60) . " mins ago";
    if ($diff < 86400) return round($diff / 3600) . " hours ago";
    return round($diff / 86400) . " days ago";
}

$vms_res = $conn->query("SELECT * FROM vms ORDER BY unit_id ASC");
$vms = [];
$stats = ['total' => 0, 'online' => 0, 'offline' => 0, 'anomaly' => 0];
$groups = [];

while($row = $vms_res->fetch_assoc()) {
    $vms[] = $row;
    $stats['total']++;

    $st = strtolower($row['status'] ?? '');
    
    $isOnline = (
        !empty($row['last_heartbeat']) &&
        strtotime($row['last_heartbeat']) >= strtotime('-5 minutes')
    );
    
    if (in_array($st, ['blocked', 'anomaly'])) {
        $stats['anomaly']++;
    }
    elseif ($isOnline) {
        $stats['online']++;
    }
    else {
        $stats['offline']++;
    }

     
    if(!empty($row['group_name'])) $groups[] = $row['group_name'];
}
$groups = array_unique($groups);
?>

<style>
    .inventory-container { font-family: 'Rajdhani', sans-serif; color: #e0e0e0; padding: 20px; }
    .page-title { font-family: 'Orbitron', sans-serif; font-size: 24px; color: #fff; margin-bottom: 30px; }
    .cyber-stat { background: #111; border: 1px solid #222; border-radius: 8px; padding: 15px; position: relative; overflow: hidden; }
    .cyber-stat::before { content: ''; position: absolute; left: 0; top: 0; bottom: 0; width: 4px; }
    .stat-total::before { background: #d32f2f; }
    .stat-online::before { background: #00c853; }
    .stat-offline::before { background: #f44336; }
    .stat-anomaly::before { background: #ffd600; }
    .filter-box { background: #0a0a0a; border: 1px solid #1a1a1a; padding: 15px; border-radius: 8px; }
    .form-control-cyber { background: #000; border: 1px solid #333; color: #fff; border-radius: 4px; font-size: 14px; }
    .table-cyber { width: 100%; border-collapse: separate; border-spacing: 0; margin-top: 20px; border: 1px solid #d32f2f33; }
    .table-cyber th { background: #000; color: #d32f2f; font-family: 'Orbitron', sans-serif; font-size: 11px; padding: 12px; border-bottom: 1px solid #d32f2f; text-transform: uppercase; }
    .table-cyber td { background: #050505; padding: 12px; font-size: 13px; border-bottom: 1px solid #111; vertical-align: middle; color: #fff !important;}
    .status-pill { padding: 2px 10px; border-radius: 10px; font-size: 10px; font-weight: bold; text-transform: uppercase; }
    .pill-online { background: rgba(0, 200, 83, 0.2); color: #00c853; border: 1px solid #00c853; }
    .pill-offline { background: rgba(244, 67, 54, 0.2); color: #f44336; border: 1px solid #f44336; }
    .token-text { color: #d32f2f; font-size: 11px; word-break: break-all; max-width: 150px; display: inline-block; font-family: monospace; }
    .copy-btn { background: #1a1a1a; border: 1px solid #333; color: #d32f2f; padding: 4px 8px; border-radius: 4px; cursor: pointer; margin-left: 8px; transition: 0.2s; }
    .copy-btn:hover { background: #d32f2f; color: #fff; }
</style>

<div class="inventory-container">
    <div class="d-flex justify-content-between align-items-center mb-4 filter-box">
        <h5 class="m-0 page-title">VM INVENTORY</h5>
        <div class="d-flex gap-2">
            <select id="filterGroup" class="form-control-cyber px-3">
                <option value="">All Groups</option>
                <?php foreach($groups as $g): ?> <option value="<?= htmlspecialchars($g) ?>"><?= htmlspecialchars($g) ?></option> <?php endforeach; ?>
            </select>
            <input type="text" id="inventorySearch" class="form-control-cyber px-3" placeholder="Search Unit ID...">
            <button class="btn btn-danger px-4" onclick="location.reload()">REFRESH</button>
        </div>
    </div>

    <div class="row g-3 mb-4 text-white">
        <div class="col-md-3"><div class="cyber-stat stat-total"><span class="fs-4 fw-bold"><?= $stats['total'] ?></span><br><small>TOTAL</small></div></div>
        <div class="col-md-3"><div class="cyber-stat stat-online"><span class="fs-4 fw-bold"><?= $stats['online'] ?></span><br><small>ONLINE</small></div></div>
        <div class="col-md-3"><div class="cyber-stat stat-offline"><span class="fs-4 fw-bold"><?= $stats['offline'] ?></span><br><small>OFFLINE</small></div></div>
        <div class="col-md-3"><div class="cyber-stat stat-anomaly"><span class="fs-4 fw-bold"><?= $stats['anomaly'] ?></span><br><small>ANOMALY</small></div></div>
    </div>

    <div class="table-responsive">
        <table class="table-cyber" id="inventoryTable">
            <thead>
                <tr>
                    <th>Unit ID</th>
                    <th>Group</th>
                    <th>RDP</th>
                    <th>IP Address</th>
                    <th>Status</th>
                    <th>Earnapp Link</th>
                    <th>Running</th>
                    <th>Last Heartbeat</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($vms as $v): 
                    $isOnline = in_array(strtolower($v['status'] ?? ''), ['active', 'online', 'ok']);
                ?>
                <tr class="vm-row" data-group="<?= htmlspecialchars($v['group_name'] ?? '') ?>">
                    <td class="fw-bold"><?= htmlspecialchars($v['unit_id'] ?? '') ?></td>
                    <td><?= htmlspecialchars($v['group_name'] ?? '') ?></td>
                    <td><?= htmlspecialchars($v['rdp_nickname'] ?? '') ?></td>
                    <td class="small text-muted"><?= $v['current_ip'] ?? $v['ip_address'] ?? '-' ?></td>
                    <td><span class="status-pill <?= $isOnline ? 'pill-online' : 'pill-offline' ?>"><?= strtoupper($v['status'] ?? 'OFFLINE') ?></span></td>
                    <td>
                        <?php if(!empty($v['earnapp_token'])): ?>
                            <span class="token-text"><?= htmlspecialchars($v['earnapp_token']) ?></span>
                            <button class="copy-btn" onclick="copyToken('https://earnapp.com/dashboard/link/<?= htmlspecialchars($v['earnapp_token']) ?>', this)">
                                <i class="fas fa-copy"></i>
                            </button>
                        <?php else: ?>
                            <span class="text-danger">Missing</span>
                        <?php endif; ?>
                    </td>
                    <td style="color: <?= $isOnline ? '#00c853' : '#f44336' ?>"><?= $isOnline ? 'YES' : 'NO' ?></td>
                    <td><?= timeAgo($v['last_heartbeat'] ?? '') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
function copyToken(text, btn) {
    navigator.clipboard.writeText(text).then(() => {
        const icon = btn.innerHTML;
        btn.innerHTML = '<i class="fas fa-check"></i>';
        btn.style.color = '#00c853';
        setTimeout(() => {
            btn.innerHTML = icon;
            btn.style.color = '#d32f2f';
        }, 1500);
    });
}

document.getElementById('inventorySearch').addEventListener('input', function() {
    let search = this.value.toLowerCase();
    document.querySelectorAll('.vm-row').forEach(row => {
        row.style.display = row.innerText.toLowerCase().includes(search) ? "" : "none";
    });
});

document.getElementById('filterGroup').addEventListener('change', function() {
    let group = this.value;
    document.querySelectorAll('.vm-row').forEach(row => {
        row.style.display = (group === "" || row.getAttribute('data-group') === group) ? "" : "none";
    });
});
</script>