<?php
require_once 'db.php';

$threshold = 0.29;

if (isset($_GET['fetch']) && $_GET['fetch'] == '1') {
    set_time_limit(0);
    $vms_query = $conn->query("SELECT * FROM vms WHERE earnapp_token IS NOT NULL AND earnapp_token != ''");
    while ($vm = $vms_query->fetch_assoc()) {
        $token = trim($vm['earnapp_token']);
        $ch = curl_init("https://earnapp.com/api/v2/money");
        curl_setopt_array($ch, [
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 20,
            CURLOPT_HTTPHEADER => [
                "Authorization: Bearer " . $token,
                "User-Agent: Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36"
            ],
        ]);
        $response = curl_exec($ch);
        $data = json_decode($response, true);
        curl_close($ch);

        if (isset($data['balance'])) {
            $new_balance = (float)$data['balance'];
            $new_traffic = (float)($data['total_earnings'] ?? 0);
            $conn->query("UPDATE vms SET balance = $new_balance, traffic = $new_traffic, last_updated = CURRENT_TIMESTAMP WHERE id = " . $vm['id']);
            
            $vm_id = $conn->real_escape_string((string)$vm['vm_id']);
            $rdp = $conn->real_escape_string((string)$vm['rdp_nickname']);
            $group = $conn->real_escape_string((string)$vm['group_name']);
            $ip = $conn->real_escape_string((string)($vm['current_ip'] ?? '0.0.0.0'));
            $token_esc = $conn->real_escape_string($token);

            $conn->query("INSERT IGNORE INTO earnapp_history (vm_id, unit_id, group_name, rdp_nickname, balance, total, ip_address, earnapp_token, recorded_at) 
                          VALUES ('$vm_id', '$group', '$rdp', '$new_balance', '$new_traffic', '$ip', '$token_esc', UTC_TIMESTAMP())");
        }
    }
    header("Location: index.php?page=earnings");
    exit;
}

$today_res = $conn->query("SELECT SUM(balance) as total FROM vms")->fetch_assoc();
$today_total = (float)($today_res['total'] ?? 0);

$week_res = $conn->query("SELECT SUM(balance) as total FROM earnapp_history WHERE recorded_at >= DATE_SUB(UTC_TIMESTAMP(), INTERVAL 7 DAY)")->fetch_assoc();
$week_total = (float)($week_res['total'] ?? 0);

$month_res = $conn->query("SELECT SUM(balance) as total FROM earnapp_history WHERE recorded_at >= DATE_SUB(UTC_TIMESTAMP(), INTERVAL 30 DAY)")->fetch_assoc();
$month_total = (float)($month_res['total'] ?? 0);

$vms_query = $conn->query("
    SELECT v.*, 
    COALESCE((SELECT h.balance FROM earnapp_history h WHERE h.vm_id = v.vm_id AND DATE(h.recorded_at) = UTC_DATE() ORDER BY h.recorded_at ASC LIMIT 1), v.balance) as day_start_bal,
    COALESCE((SELECT h.balance FROM earnapp_history h WHERE h.vm_id = v.vm_id AND DATE(h.recorded_at) = SUBDATE(UTC_DATE(), 1) ORDER BY h.recorded_at ASC LIMIT 1), 0) as yest_start_bal,
    COALESCE((SELECT h.balance FROM earnapp_history h WHERE h.vm_id = v.vm_id AND DATE(h.recorded_at) = SUBDATE(UTC_DATE(), 1) ORDER BY h.recorded_at DESC LIMIT 1), 0) as yest_end_bal
    FROM vms v
");

$all_vms = [];
$stats = ['total' => 0, 'ok' => 0, 'blocked' => 0, 'unchecked' => 0];
$sums = ['today' => 0, 'yesterday' => 0];

while($row = $vms_query->fetch_assoc()) {
    $cur = (float)($row['balance'] ?? 0);
    $today_start = (float)($row['day_start_bal'] ?? 0);
    $y_start = (float)($row['yest_start_bal'] ?? 0);
    $y_end = (float)($row['yest_end_bal'] ?? 0);

    $t_earn = max(0, $cur - $today_start);
    $y_earn = max(0, $y_end - $y_start);
    $change = ($y_earn > 0) ? (($t_earn - $y_earn) / $y_earn) * 100 : 0;

    $st = strtolower($row['status'] ?? 'offline');
    $all_vms[] = [
        'vm' => $row['unit_id'],
        'rdp' => $row['rdp_nickname'],
        'group' => $row['group_name'],
        'ip' => $row['current_ip'] ?? '0.0.0.0',
        'today' => $t_earn,
        'yesterday' => $y_earn,
        'total' => $cur,
        'change' => $change,
        'status' => $row['status']
    ];

    $stats['total']++;

    $isOnline = (
        !empty($row['last_heartbeat']) &&
        strtotime($row['last_heartbeat']) >= strtotime('-5 minutes')
    );
    
    $st = strtolower($row['status'] ?? '');
    
    if (in_array($st, ['blocked', 'anomaly'])) {
        $stats['blocked']++;
    }
    elseif ($isOnline) {
        $stats['ok']++;
    }
    else {
        $stats['unchecked']++;
    }


    $sums['today'] += $t_earn;
    $sums['yesterday'] += $y_earn;
}

$by_group = [];
$by_rdp = [];
$blocked_ips = [];
$blocked_subnets = [];

foreach($all_vms as $v) {
    $g = $v['group'] ?? 'Unknown';
    $r = $v['rdp'] ?? 'Unknown';
    if(!isset($by_group[$g])) $by_group[$g] = ['rdps' => [], 'vms' => 0, 'today' => 0, 'yesterday' => 0, 'below' => 0];
    $by_group[$g]['rdps'][$r] = true;
    $by_group[$g]['vms']++;
    $by_group[$g]['today'] += $v['today'];
    $by_group[$g]['yesterday'] += $v['yesterday'];
    if($v['today'] < $threshold) $by_group[$g]['below']++;
    if(!isset($by_rdp[$r])) $by_rdp[$r] = ['group' => $g, 'vms' => 0, 'today' => 0, 'yesterday' => 0, 'blocked' => 0, 'status' => 'OK'];
    $by_rdp[$r]['vms']++;
    $by_rdp[$r]['today'] += $v['today'];
    $by_rdp[$r]['yesterday'] += $v['yesterday'];
    if(in_array(strtolower($v['status'] ?? ''), ['blocked', 'anomaly'])) {
        $by_rdp[$r]['blocked']++;
        $by_rdp[$r]['status'] = 'CRITICAL';
        $ip_p = explode('.', $v['ip']);
        $sub = (count($ip_p) == 4) ? $ip_p[0].'.'.$ip_p[1].'.'.$ip_p[2] : 'Unknown';
        $blocked_ips[] = ['ip' => $v['ip'], 'subnet' => $sub, 'vm' => $v['vm'], 'rdp' => $r, 'today' => $v['today']];
        $blocked_subnets[$sub] = true;
    }
}
?>

<style>
    :root { --bg: #050505; --card: #0d0d0d; --border: #1a1a1a; --accent: #d32f2f; --green: #00c853; --gray: #888; }
    .stat-card { background: var(--card); border: 1px solid var(--border); border-radius: 8px; padding: 15px; display: flex; align-items: center; gap: 15px; }
    .stat-icon { width: 40px; height: 40px; display: flex; align-items: center; justify-content: center; border-radius: 6px; font-size: 18px; }
    .nav-pills .nav-link { color: var(--gray); background: #111; margin-right: 8px; border-radius: 4px; font-size: 12px; border: none; padding: 8px 16px; }
    .nav-pills .nav-link.active { background: var(--accent); color: #fff; }
    .table-ui { width: 100%; border-collapse: separate; border-spacing: 0; background: transparent; }
    .table-ui th { padding: 12px; font-size: 11px; text-transform: uppercase; color: #555; border-bottom: 1px solid #111; }
    .table-ui td { padding: 12px; font-size: 13px; color: #ccc; border-bottom: 1px solid #111; vertical-align: middle; }
    .badge-threshold { background: #ff9800; color: #000; padding: 2px 8px; border-radius: 10px; font-weight: bold; font-size: 11px; }
    .badge-ok { background: rgba(0, 200, 83, 0.1); color: var(--green); border: 1px solid var(--green); font-size: 10px; padding: 2px 8px; border-radius: 4px; }
    .badge-critical { background: rgba(211, 47, 47, 0.1); color: var(--accent); border: 1px solid var(--accent); font-size: 10px; padding: 2px 8px; border-radius: 4px; }
    .btn-replace { font-size: 10px; padding: 4px 10px; background: #222; border: 1px solid #333; color: #888; border-radius: 4px; text-transform: uppercase; }
</style>

<div class="container-fluid p-4">
    <div class="row g-3 mb-4 text-white text-center">
        <div class="col-md-3">
            <div class="stat-card">
                <div><small class="text-muted">TODAY</small><br><span class="fs-4 fw-bold">$<?= number_format((float)($today_total ?? 0), 2) ?></span></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div><small class="text-muted">THIS WEEK</small><br><span class="fs-4 fw-bold">$<?= number_format((float)($week_total ?? 0), 2) ?></span></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div><small class="text-muted">THIS MONTH</small><br><span class="fs-4 fw-bold">$<?= number_format((float)($month_total ?? 0), 2) ?></span></div>
            </div>
        </div>
        <div class="col-md-3">
            <div class="stat-card">
                <div><small class="text-muted">YESTERDAY</small><br><span class="fs-4 fw-bold">$<?= number_format((float)($sums['yesterday'] ?? 0), 2) ?></span></div>
            </div>
        </div>
    </div>

    <div class="row g-3 mb-4 text-white">
        <div class="col-md-3"><div class="stat-card"><div class="stat-icon bg-dark"><i class="fas fa-desktop"></i></div><div><span class="fs-4 fw-bold"><?= (int)$stats['total'] ?></span><br><small class="text-muted">TOTAL VMS</small></div></div></div>
        <div class="col-md-3"><div class="stat-card"><div class="stat-icon" style="background:rgba(0,200,83,0.1);color:var(--green)"><i class="fas fa-check-circle"></i></div><div><span class="fs-4 fw-bold"><?= (int)$stats['ok'] ?></span><br><small class="text-muted">OK</small></div></div></div>
        <div class="col-md-3"><div class="stat-card"><div class="stat-icon" style="background:rgba(211,47,47,0.1);color:var(--accent)"><i class="fas fa-ban"></i></div><div><span class="fs-4 fw-bold"><?= (int)$stats['blocked'] ?></span><br><small class="text-muted">BLOCKED</small></div></div></div>
        <div class="col-md-3"><div class="stat-card"><div class="stat-icon" style="background:rgba(255,214,0,0.1);color:#ffd600"><i class="fas fa-question-circle"></i></div><div><span class="fs-4 fw-bold"><?= (int)$stats['unchecked'] ?></span><br><small class="text-muted">UNCHECKED</small></div></div></div>
    </div>

    <div class="d-flex justify-content-between align-items-center mb-4">
        <ul class="nav nav-pills" id="mainTabs">
            <li class="nav-item"><button class="nav-link active" data-bs-toggle="pill" data-bs-target="#tab-all">All VMs</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#tab-blocked">Blocked IPs</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#tab-rdp">By RDP</button></li>
            <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#tab-group">By Group</button></li>
        </ul>
        <a href="?page=earnings&fetch=1" class="btn btn-sm btn-danger px-3"><i class="fas fa-sync-alt me-2"></i> REFRESH</a>
    </div>

    <div class="tab-content">
        <div class="tab-pane fade show active" id="tab-all">
            <table class="table-ui">
                <thead><tr><th>VM</th><th>RDP</th><th>Group</th><th>IP</th><th>Today</th><th>Yesterday</th><th>Total</th><th>Status</th></tr></thead>
                <tbody>
                    <?php foreach($all_vms as $v): ?>
                    <tr>
                        <td><?= htmlspecialchars((string)($v['vm'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($v['rdp'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($v['group'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($v['ip'] ?? '')) ?></td>
                        <td>$<?= number_format((float)($v['today'] ?? 0), 4) ?></td>
                        <td>$<?= number_format((float)($v['yesterday'] ?? 0), 4) ?></td>
                        <td class="text-green">$<?= number_format((float)($v['total'] ?? 0), 2) ?></td>
                        <td><span class="<?= strtolower($v['status'] ?? '') == 'online' ? 'text-green' : 'text-danger' ?> small fw-bold"><?= strtoupper((string)($v['status'] ?? '')) ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="tab-pane fade" id="tab-blocked">
            <table class="table-ui mb-3">
                <thead><tr><th>IP</th><th>Subnet</th><th>VM</th><th>RDP</th><th>Today $</th><th>Action</th></tr></thead>
                <tbody>
                    <?php foreach($blocked_ips as $b): ?>
                    <tr>
                        <td><?= htmlspecialchars((string)($b['ip'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($b['subnet'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($b['vm'] ?? '')) ?></td>
                        <td><?= htmlspecialchars((string)($b['rdp'] ?? '')) ?></td>
                        <td class="text-danger">$<?= number_format((float)($b['today'] ?? 0), 4) ?></td>
                        <td><button class="btn-replace">Replace IP</button></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
            <div class="p-3 bg-dark rounded small text-muted"><strong>Blocked Subnets:</strong> <?= htmlspecialchars(implode(', ', array_keys($blocked_subnets))) ?></div>
        </div>

        <div class="tab-pane fade" id="tab-rdp">
            <table class="table-ui">
                <thead><tr><th>RDP</th><th>Group</th><th>VMs</th><th>Today</th><th>Yesterday</th><th>Change</th><th>Blocked</th><th>Status</th></tr></thead>
                <tbody>
                    <?php foreach($by_rdp as $rName => $d): $ch = ($d['yesterday'] > 0) ? (($d['today'] - $d['yesterday']) / $d['yesterday']) * 100 : 0; ?>
                    <tr>
                        <td><?= htmlspecialchars((string)$rName) ?></td>
                        <td><?= htmlspecialchars((string)($d['group'] ?? '')) ?></td>
                        <td><?= (int)$d['vms'] ?></td>
                        <td>$<?= number_format((float)($d['today'] ?? 0), 4) ?></td>
                        <td>$<?= number_format((float)($d['yesterday'] ?? 0), 4) ?></td>
                        <td class="<?= $ch < 0 ? 'text-danger' : 'text-green' ?>"><?= number_format((float)$ch, 1) ?>%</td>
                        <td><?= (int)$d['blocked'] ?></td>
                        <td><span class="<?= ($d['status'] ?? '') == 'OK' ? 'badge-ok' : 'badge-critical' ?>"><?= htmlspecialchars((string)($d['status'] ?? '')) ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="tab-pane fade" id="tab-group">
            <table class="table-ui">
                <thead><tr><th>Group</th><th>RDPs</th><th>VMs</th><th>Today</th><th>Yesterday</th><th>Change</th><th>Avg/VM</th><th>Below Threshold</th></tr></thead>
                <tbody>
                    <?php foreach($by_group as $gName => $d): $ch = ($d['yesterday'] > 0) ? (($d['today'] - $d['yesterday']) / $d['yesterday']) * 100 : 0; ?>
                    <tr>
                        <td class="fw-bold"><?= htmlspecialchars((string)$gName) ?></td>
                        <td><?= count($d['rdps'] ?? []) ?></td>
                        <td><?= (int)$d['vms'] ?></td>
                        <td>$<?= number_format((float)($d['today'] ?? 0), 4) ?></td>
                        <td>$<?= number_format((float)($d['yesterday'] ?? 0), 4) ?></td>
                        <td class="<?= $ch < 0 ? 'text-danger' : 'text-green' ?>"><?= number_format((float)$ch, 1) ?>%</td>
                        <td>$<?= number_format((float)(($d['today'] ?? 0) / max(1, $d['vms'])), 4) ?></td>
                        <td><span class="badge-threshold"><?= (int)$d['below'] ?></span></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>