<?php
require_once 'db.php';

$threshold = 0.29;

if (isset($_GET['fetch']) && $_GET['fetch'] == '1') {
    $vms_query = $conn->query("SELECT unit_id, rdp_nickname, group_name, balance, traffic, ip_address, earnapp_token FROM vms");
    while ($vm = $vms_query->fetch_assoc()) {

        $unit_id = $conn->real_escape_string((string)$vm['unit_id']);
        $rdp     = $conn->real_escape_string((string)$vm['rdp_nickname']);
        $group   = $conn->real_escape_string((string)$vm['group_name']);
        $balance = $conn->real_escape_string((string)$vm['balance']);
        $total   = $conn->real_escape_string((string)$vm['traffic']);
        $token   = $conn->real_escape_string((string)$vm['earnapp_token']);
        $ip      = $conn->real_escape_string((string)$vm['ip_address']);

        $conn->query("
            INSERT INTO earnapp_history 
            (unit_id, group_name, rdp_nickname, balance, total, ip_address, earnapp_token, recorded_at)
            VALUES
            ('$unit_id', '$group', '$rdp', '$balance', '$total', '$ip', '$token', UTC_TIMESTAMP())
        ");
    }

    header("Location: index.php?page=earnings");
    exit;
}

$vms_query = $conn->query("
    SELECT 
        v.*,
        COALESCE(
            (SELECT h.balance
             FROM earnapp_history h
             WHERE h.vm_id = v.vm_id
               AND DATE(h.recorded_at) < UTC_DATE()
             ORDER BY h.recorded_at DESC
             LIMIT 1), 0
        ) AS yest_closing_bal,

        COALESCE(
            (SELECT h.balance
             FROM earnapp_history h
             WHERE h.vm_id = v.vm_id
               AND DATE(h.recorded_at) < SUBDATE(UTC_DATE(), 1)
             ORDER BY h.recorded_at DESC
             LIMIT 1), 0
        ) AS day_before_closing_bal
    FROM vms v
");


$vms = [];
$stats = ['total' => 0, 'online' => 0, 'pending' => 0, 'anomalies' => 0];
$sums  = ['today' => 0, 'yesterday' => 0];

while ($row = $vms_query->fetch_assoc()) {

    $cur_bal  = (float)$row['balance'];
    $y_close  = (float)$row['yest_closing_bal'];
    $by_close = (float)$row['day_before_closing_bal'];

    $today_earn     = ($y_close > 0) ? max(0, $cur_bal - $y_close) : $cur_bal;
    $yesterday_earn = ($by_close > 0) ? max(0, $y_close - $by_close) : $y_close;

    $change = ($yesterday_earn > 0)
        ? (($today_earn - $yesterday_earn) / $yesterday_earn) * 100
        : 0;

    $status = strtolower(trim((string)$row['status']));

    $stats['total']++;

    $isOnline = (
        !empty($row['last_heartbeat']) &&
        strtotime($row['last_heartbeat']) >= strtotime('-5 minutes')
    );
    
    $status = strtolower(trim((string)$row['status']));
    
    if (in_array($status, ['blocked', 'anomaly'])) {
        $stats['anomalies']++;
    }
    elseif ($isOnline) {
        $stats['online']++;
    }
    else {
        $stats['pending']++;
    }

    $vms[] = [
        'vm'        => $row['unit_id'],
        'rdp'       => $row['rdp_nickname'],
        'group'     => $row['group_name'],
        'ip'        => $row['current_ip'] ?? $row['ip_address'],
        'today'     => $today_earn,
        'yesterday' => $yesterday_earn,
        'total'     => $cur_bal,
        'change'    => $change,
        'status'    => $row['status']
    ];

    $sums['today']     += $today_earn;
    $sums['yesterday'] += $yesterday_earn;
}

$dropped_list = array_filter($vms, function($v) { return $v['change'] < 0; });
$below_list = array_filter($vms, function($v) use ($threshold) { return $v['today'] < $threshold; });
$groups_data = [];
foreach($vms as $v) { $groups_data[$v['group']][$v['rdp']][] = $v; }
?>

<style>
    :root { --bg: #050505; --card: #0d0d0d; --border: #1a1a1a; --accent: #d32f2f; --green: #00c853; --gray: #888; }
    .stat-card { background: var(--card); border: 1px solid var(--border); border-radius: 12px; padding: 20px; }
    .nav-pills .nav-link { color: var(--gray); background: #111; margin-right: 10px; border-radius: 4px; font-size: 13px; border: none; }
    .nav-pills .nav-link.active { background: var(--accent); color: #fff; }
    .table-dark-ui { width: 100%; border-collapse: separate; border-spacing: 0 2px; }
    .table-dark-ui td { background: #0c0c0c; padding: 12px; font-size: 13px; color: #ccc; border: none; }
    .group-row { background: #121212 !important; font-weight: bold; color: #fff !important; cursor: pointer; }
    .val-main { font-size: 28px; font-weight: 700; display: block; color: #fff; }
    .val-sub { font-size: 11px; color: var(--gray); text-transform: uppercase; letter-spacing: 1px; }
    .text-green { color: var(--green) !important; }
</style>

<div class="container-fluid p-4">
    <div class="row g-3 mb-4">
        <div class="col-md-3"><div class="stat-card" style="border-left: 4px solid var(--accent);"><span class="val-main"><?= $stats['total'] ?></span><span class="val-sub">Total VMs</span></div></div>
        <div class="col-md-3"><div class="stat-card" style="border-left: 4px solid var(--green);"><span class="val-main"><?= $stats['online'] ?></span><span class="val-sub">Online</span></div></div>
        <div class="col-md-3"><div class="stat-card" style="border-left: 4px solid #555;"><span class="val-main"><?= $stats['pending'] ?></span><span class="val-sub">Pending</span></div></div>
        <div class="col-md-3"><div class="stat-card" style="border-left: 4px solid #ffd600;"><span class="val-main"><?= $stats['anomalies'] ?></span><span class="val-sub">Anomalies</span></div></div>
    </div>

    <div class="row g-3 mb-4">
        <div class="col-md-3"><div class="stat-card"><span class="val-main">$<?= number_format($sums['today'], 2) ?></span><span class="val-sub">Today</span></div></div>
        <div class="col-md-3"><div class="stat-card"><span class="val-main">$<?= number_format($sums['yesterday'], 2) ?></span><span class="val-sub">Yesterday</span></div></div>
        <div class="col-md-3"><div class="stat-card"><span class="val-main"><?= count($below_list) ?></span><span class="val-sub">Below Threshold</span></div></div>
        <div class="col-md-3"><div class="stat-card"><span class="val-main"><?= count($dropped_list) ?></span><span class="val-sub">Dropped</span></div></div>
    </div>

    <ul class="nav nav-pills mb-4">
        <li class="nav-item"><button class="nav-link active" data-bs-toggle="pill" data-bs-target="#tab-group">By Group</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#tab-all">All VMs</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#tab-dropped">Dropped</button></li>
        <li class="nav-item"><button class="nav-link" data-bs-toggle="pill" data-bs-target="#tab-below">Below Threshold</button></li>
    </ul>

    <div class="tab-content">
        <div class="tab-pane fade show active" id="tab-group">
            <?php foreach($groups_data as $gName => $rdps): ?>
                <div class="mb-3">
                    <div class="p-3 group-row mb-1"><i class="fas fa-folder me-2 text-accent"></i> <?= $gName ?></div>
                    <?php foreach($rdps as $rName => $list): ?>
                        <div class="ps-3 mb-2">
                            <div class="p-2 text-muted small border-bottom border-dark"><?= $rName ?> (<?= count($list) ?> VMs)</div>
                            <table class="table-dark-ui">
                                <thead><tr class="text-muted small"><td>VM</td><td>IP</td><td>Today</td><td>Yesterday</td><td>Total</td><td>Change</td><td>Status</td></tr></thead>
                                <tbody>
                                    <?php foreach($list as $v): ?>
                                    <tr>
                                        <td><?= $v['vm'] ?></td>
                                        <td><?= $v['ip'] ?></td>
                                        <td>$<?= number_format($v['today'], 4) ?></td>
                                        <td>$<?= number_format($v['yesterday'], 4) ?></td>
                                        <td class="text-green">$<?= number_format($v['total'], 2) ?></td>
                                        <td class="<?= $v['change'] < 0 ? 'text-danger' : 'text-green' ?>"><?= number_format($v['change'], 1) ?>%</td>
                                        <td><span class="small"><?= strtoupper($v['status']) ?></span></td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endforeach; ?>
        </div>

        <div class="tab-pane fade" id="tab-all">
            <table class="table-dark-ui">
                <thead><tr class="text-muted small"><td>VM</td><td>RDP</td><td>Group</td><td>Today</td><td>Yesterday</td><td>Total</td><td>Status</td></tr></thead>
                <tbody>
                    <?php foreach($vms as $v): ?>
                    <tr><td><?= $v['vm'] ?></td><td><?= $v['rdp'] ?></td><td><?= $v['group'] ?></td><td>$<?= number_format($v['today'], 4) ?></td><td>$<?= number_format($v['yesterday'], 4) ?></td><td>$<?= number_format($v['total'], 2) ?></td><td><?= strtoupper($v['status']) ?></td></tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="tab-pane fade" id="tab-dropped">
            <table class="table-dark-ui">
                <thead><tr class="text-muted small"><td>VM</td><td>RDP</td><td>Yesterday</td><td>Today</td><td>Drop %</td></tr></thead>
                <tbody>
                    <?php foreach($dropped_list as $v): ?>
                    <tr><td><?= $v['vm'] ?></td><td><?= $v['rdp'] ?></td><td>$<?= number_format($v['yesterday'], 4) ?></td><td class="text-danger">$<?= number_format($v['today'], 4) ?></td><td class="text-danger"><?= number_format($v['change'], 1) ?>%</td></tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <div class="tab-pane fade" id="tab-below">
            <table class="table-dark-ui">
                <thead><tr class="text-muted small"><td>VM</td><td>RDP</td><td>Group</td><td>Today</td><td>Threshold</td></tr></thead>
                <tbody>
                    <?php foreach($below_list as $v): ?>
                    <tr><td><?= $v['vm'] ?></td><td><?= $v['rdp'] ?></td><td><?= $v['group'] ?></td><td class="text-danger">$<?= number_format($v['today'], 4) ?></td><td>$<?= number_format($threshold, 2) ?></td></tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>