<?php
/**
 * Agent Update Check API
 * GET /api/vm/update_check.php?version=X.X.X
 *
 * Returns: { update_available, version, sha256 }
 *
 * HOW TO RELEASE A NEW VERSION:
 *   1. Update agent.ps1 with new code and bump $AGENT_VERSION = "X.X.X"
 *   2. Update CURRENT_VERSION below to match
 *   3. Run: sha256sum static/agent.ps1  (or Get-FileHash in PowerShell)
 *   4. Paste the hash into AGENT_SHA256 below
 *   All agents will auto-update within 30 minutes.
 */

header('Content-Type: application/json');
header('Cache-Control: no-store, no-cache, must-revalidate');

// ── RELEASE CONFIGURATION ────────────────────────────────────────────────────
define('CURRENT_VERSION', '3.0.0');

$agentPath = __DIR__ . '/../../static/agent.ps1';

// Auto-compute SHA256 from the live file (always accurate, no manual update needed)
if (!file_exists($agentPath)) {
    http_response_code(500);
    echo json_encode(['error' => 'agent.ps1 not found on server']);
    exit;
}

$serverHash = strtoupper(hash_file('sha256', $agentPath));

// ── VERSION COMPARISON ───────────────────────────────────────────────────────
$clientVersion = trim($_GET['version'] ?? '0.0.0');

function version_newer($server, $client) {
    return version_compare($server, $client, '>');
}

$updateAvailable = version_newer(CURRENT_VERSION, $clientVersion);

echo json_encode([
    'update_available' => $updateAvailable,
    'version'          => CURRENT_VERSION,
    'sha256'           => $serverHash,
    'checked_at'       => date('Y-m-d H:i:s'),
]);