<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['user_id'])) {
    header("Location: ./login.php");
    exit;
}

require_once __DIR__ . '/../db.php';

/* current user fetch */
$stmt = $conn->prepare("SELECT username, avatar FROM users WHERE id = ? LIMIT 1");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$stmt->bind_result($username, $avatar);
$stmt->fetch();
$stmt->close();

$user = [
    'username' => $username,
    'avatar' => $avatar
];

$currentUsername = $user['username'] ?? 'Unknown';
?>

<div class="container-fluid px-4 py-3">

  <!-- STATS -->
<div id="top-stats-wrapper">
    <?php include __DIR__ . '/../parts/vm_top_stats.php'; ?>
</div>

  <!-- SETTINGS TITLE -->
  <h4 class="mb-3 text-white">
    <i class="fa-solid fa-gear me-2"></i> Settings
  </h4>

  <!-- PROFILE + PASSWORD -->
  <div class="row">
    <div class="col-lg-12">
      <div class="card bg-dark text-white red-border">

        <div class="card-header">
          <i class="fa-solid fa-user text-danger me-2"></i> My Profile
        </div>
        
        <?php if (!empty($_SESSION['flash'])): ?>
  <div class="alert alert-<?= $_SESSION['flash']['type'] ?> alert-dismissible fade show">
    <?= htmlspecialchars($_SESSION['flash']['msg']) ?>
    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
  </div>
  <?php unset($_SESSION['flash']); ?>
<?php endif; ?>

<div class="card-body">
 
  <form method="post" action="/earnapp/change_password.php" enctype="multipart/form-data">

<?php
$avatar = $user['avatar'] ?? '';
$avatarUrl = $avatar ? "/earnapp/uploads/avatars/".$avatar : "/earnapp/assets/img/default-avatar.png";
?>

<div class="d-flex align-items-center mb-4 gap-3">
  <img src="<?= htmlspecialchars($avatarUrl) ?>"
       style="width:80px;height:80px;border-radius:50%;object-fit:cover;border:2px solid #b30000">

  <div>
    <label class="form-label mb-1">Profile Image</label>
    <input type="file"
           name="avatar"
           accept="image/png,image/jpeg,image/webp"
           class="form-control bg-black text-white border-danger">
    <small class="">PNG / JPG / WEBP • max 2MB</small>
  </div>
</div>
   <!-- PROFILE -->
  <h6 class="text-uppercase text-danger mb-3">
    <i class="fa-solid fa-id-badge me-2"></i> Profile
  </h6>

  <div class="mb-3">
    <label class="form-label ">Username</label>
    <input type="text"
           name="username"
           value="<?= htmlspecialchars($currentUsername) ?>"
           class="form-control bg-black text-white border-danger"
           required>
  </div>

   
<div class="mb-3">
  <label class="form-label ">New Password</label>
  <div class="input-group">
    <input type="password"
           name="new_password"
           id="new_password"
           class="form-control bg-black text-white border-danger"
           placeholder="Leave blank to keep current password">
    <span class="input-group-text bg-black border-danger text-danger"
          onclick="togglePwd('new_password', this)">
      <i class="fa-solid fa-eye"></i>
    </span>
  </div>
</div>

<div class="mb-4">
  <label class="form-label ">Confirm New Password</label>
  <div class="input-group">
    <input type="password"
           name="confirm_password"
           id="confirm_password"
           class="form-control bg-black text-white border-danger">
    <span class="input-group-text bg-black border-danger text-danger"
          onclick="togglePwd('confirm_password', this)">
      <i class="fa-solid fa-eye"></i>
    </span>
  </div>
</div>

  <button class="btn btn-danger px-4">
    Update Profile
  </button>

  </form>

</div>

      </div>
    </div>
  </div>

</div>
<script>
function togglePwd(id, el) {
    const input = document.getElementById(id);
    const icon = el.querySelector('i');

    if (input.type === 'password') {
        input.type = 'text';
        icon.classList.remove('fa-eye');
        icon.classList.add('fa-eye-slash');
    } else {
        input.type = 'password';
        icon.classList.remove('fa-eye-slash');
        icon.classList.add('fa-eye');
    }
}
</script>
