<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!is_array($data) || empty($data['vm_id'])) {
    echo json_encode(['status' => 'error', 'msg' => 'vm_id missing']);
    exit;
}

$vmId        = (int)$data['vm_id'];
$isHeartbeat = (isset($data['action']) && $data['action'] === 'heartbeat');
$ip          = $conn->real_escape_string(trim($data['ip_address']    ?? $_SERVER['REMOTE_ADDR'] ?? ''));
$token       = $conn->real_escape_string(trim($data['earnapp_token'] ?? ''));
$group       = $conn->real_escape_string(trim($data['group_name']    ?? ''));
$rdp         = $conn->real_escape_string(trim($data['rdp_nickname']  ?? ''));

$statRaw = trim($data['status'] ?? '');
$allowed = ['Running', 'Blocked', 'Paused', 'Connecting', 'Offline', 'Online'];
$stat    = in_array($statRaw, $allowed, true) ? $statRaw : '';
if ($stat === 'Connecting') $stat = 'Offline';
$statSafe = $conn->real_escape_string($stat);

$bal  = null;
if (isset($data['balance']) && $data['balance'] !== '') {
    $bal = (float)preg_replace('/[^0-9.]/', '', (string)$data['balance']);
}
$traf = (float)preg_replace('/[^0-9.]/', '', (string)($data['traffic'] ?? '0'));

$row = $conn->query("SELECT id, status FROM vms WHERE id = $vmId LIMIT 1");
if (!$row || $row->num_rows === 0) {
    echo json_encode(['status' => 'error', 'msg' => 'VM not registered']);
    exit;
}
$vm              = $row->fetch_assoc();
$currentDbStatus = $vm['status'] ?? '';

if ($token !== '') {
    $dup = $conn->query("SELECT id FROM vms WHERE earnapp_token = '$token' AND id != $vmId LIMIT 1");
    if ($dup && $dup->num_rows > 0) {
        $oldRow = $dup->fetch_assoc();
        $conn->query("UPDATE vms SET earnapp_token = NULL, status = 'Offline' WHERE id = " . (int)$oldRow['id']);
    }
}

$sets = [];
$sets[] = "current_ip = '$ip'";
$sets[] = "last_heartbeat = NOW()";

$shouldUpdateStatus = false;
if ($stat === 'Online' && in_array($currentDbStatus, ['Offline', '', null], true)) {
    $shouldUpdateStatus = true;
} elseif ($stat !== '' && $stat !== 'Online') {
    $shouldUpdateStatus = true;
}
if ($shouldUpdateStatus) {
    $sets[] = "status = '$statSafe'";
}

if (!$isHeartbeat) {
    $sets[] = "traffic = $traf";
    if ($token !== '') {
        $sets[] = "earnapp_token = '$token'";
    }
    if ($bal !== null) {
        $sets[] = "balance = $bal";
    }
}

$sql = "UPDATE vms SET " . implode(', ', $sets) . " WHERE id = $vmId";
if (!$conn->query($sql)) {
    echo json_encode(['status' => 'error', 'msg' => 'Update failed: ' . $conn->error]);
    exit;
}

if (!$isHeartbeat && $token !== '' && in_array($stat, ['Running', 'Blocked', 'Paused'], true)) {
    $balHist = ($bal !== null) ? (float)$bal : 0.0;
    $conn->query("INSERT INTO earnapp_history (vm_id, earnapp_token, ip_address, redeem_balance, cashout_detected, status, earning_date, recorded_at) VALUES ($vmId, '$token', '$ip', $balHist, 0, '$statSafe', CURDATE(), NOW())");
}

echo json_encode(['status' => 'success']);
?>