<?php
require_once 'db.php';
date_default_timezone_set('UTC');

function timeAgo($timestamp) {
    if (!$timestamp || $timestamp === '0000-00-00 00:00:00') return 'Never';

    $curTime = strtotime($timestamp);
    if ($curTime === false) return 'Never';

    $now  = strtotime(gmdate('Y-m-d H:i:s'));
    $diff = max(1, $now - $curTime);

    if ($diff < 60) return $diff . ' sec ago';
    if ($diff < 3600) return floor($diff / 60) . ' min ago';
    if ($diff < 86400) return floor($diff / 3600) . ' hr ago';
    return floor($diff / 86400) . ' day ago';
}

$vms = [];
$stats = ['total' => 0, 'online' => 0, 'offline' => 0, 'anomaly' => 0];

$vms_res = $conn->query("SELECT * FROM vms ORDER BY unit_id ASC");
while ($row = $vms_res->fetch_assoc()) {
    $vms[] = $row;
    $stats['total']++;

    $st = strtolower($row['status'] ?? '');
    $isOnline = !empty($row['last_heartbeat']) && strtotime($row['last_heartbeat']) >= strtotime('-5 minutes');

    if (in_array($st, ['blocked', 'anomaly'])) {
        $stats['anomaly']++;
    } elseif ($isOnline) {
        $stats['online']++;
    } else {
        $stats['offline']++;
    }
}

$groups = [];
$gRes = $conn->query("
    SELECT DISTINCT TRIM(group_name) AS gname
    FROM vms
    WHERE group_name IS NOT NULL AND group_name <> ''
    ORDER BY gname ASC
");
while ($g = $gRes->fetch_assoc()) {
    $groups[] = $g['gname'];
}
?>
<style>
    :root {
        --cyber-red: #ff4444;
        --cyber-green: #00c853;
        --cyber-bg: #0a0a0a;
        --cyber-card: #111;
        --cyber-border: rgba(255, 68, 68, 0.2);
    }

    .inventory-container {
        background: var(--cyber-bg);
        color: #fff;
        padding: 20px;
        font-family: 'Segoe UI', Roboto, sans-serif;
    }

    .filter-box {
        background: #111;
        padding: 15px;
        border-left: 3px solid var(--cyber-red);
        margin-bottom: 20px;
    }

    .form-control-cyber {
        background: #1a1a1a;
        border: 1px solid #333;
        color: #fff;
        padding: 8px 15px;
        border-radius: 4px;
    }

    .cyber-stat {
        background: #111;
        padding: 20px;
        text-align: center;
        border: 1px solid var(--cyber-border);
        border-radius: 5px;
        position: relative;
        transition: 0.3s;
    }
    
    .stat-total { border-left: 4px solid #fff; }
    .stat-online { border-left: 4px solid var(--cyber-green); }
    .stat-offline { border-left: 4px solid var(--cyber-red); }
    .stat-anomaly { border-left: 4px solid #ffbb33; }

    .table-cyber {
        width: 100%;
        border-collapse: collapse;
        background: #111;
        margin-top: 20px;
    }

    .table-cyber th {
        background: #1a1a1a;
        color: var(--cyber-red);
        text-transform: uppercase;
        font-size: 12px;
        padding: 12px;
        text-align: left;
        border-bottom: 2px solid #333;
    }

    .table-cyber td {
        padding: 12px;
        border-bottom: 1px solid #222;
        font-size: 13px;
    }

    .status-pill {
        padding: 4px 10px;
        border-radius: 3px;
        font-weight: bold;
        font-size: 11px;
    }

    .pill-online { background: rgba(0, 200, 83, 0.2); color: #00c853; border: 1px solid #00c853; }
    .pill-offline { background: rgba(244, 67, 54, 0.2); color: #f44336; border: 1px solid #f44336; }

    .earnapp-wrap {
        display: flex;
        align-items: center;
        gap: 10px;
        background: #000;
        padding: 5px;
        border-radius: 4px;
        max-width: 250px;
    }

    .token-text {
        overflow: hidden;
        text-overflow: ellipsis;
        white-space: nowrap;
        color: var(--cyber-red);
        font-family: monospace;
    }

    .copy-btn {
        background: transparent;
        border: none;
        color: var(--cyber-red);
        cursor: pointer;
    }
</style>

<div class="inventory-container">
    <!-- Header & Filters -->
    <div class="d-flex justify-content-between align-items-center mb-4 filter-box">
        <h5 class="m-0 page-title">VM INVENTORY</h5>
       
    </div>

    <!-- Stats Cards -->
    <div class="row g-3 mb-4 text-white">
        <div class="col-md-3"><div class="cyber-stat stat-total"><span id="statTotal" class="fs-4 fw-bold"><?= $stats['total'] ?></span><br><small>TOTAL VMS</small></div></div>
        <div class="col-md-3"><div class="cyber-stat stat-online"><span id="statOnline" class="fs-4 fw-bold"><?= $stats['online'] ?></span><br><small>ONLINE</small></div></div>
        <div class="col-md-3"><div class="cyber-stat stat-offline"><span id="statOffline" class="fs-4 fw-bold"><?= $stats['offline'] ?></span><br><small>OFFLINE</small></div></div>
        <div class="col-md-3"><div class="cyber-stat stat-anomaly"><span id="statAnomaly" class="fs-4 fw-bold"><?= $stats['anomaly'] ?></span><br><small>ANOMALIES</small></div></div>
    </div>

    <!-- Data Table -->
    <div class="table-responsive">
        <table class="table-cyber" id="inventoryTable">
            <thead>
                <tr>
                    <th>Unit ID</th>
                    <th>Group</th>
                    <th>RDP</th>
                    <th>IP Address</th>
                    <th>Status</th>
                    <th>Earnapp Link</th>
                    <th>Running</th>
                    <th>Last Heartbeat</th>
                </tr>
            </thead>
            <tbody id="vmTableBody">
                <?php foreach($vms as $v): 
                    $isOnline = (!empty($v['last_heartbeat']) && strtotime($v['last_heartbeat']) >= strtotime('-5 minutes'));
                ?>
                <tr class="vm-row-item" data-group="<?= htmlspecialchars(trim($v['group_name'] ?? '')) ?>">
                    <td class="fw-bold" style="color: #fff;"><?= htmlspecialchars($v['unit_id'] ?? '') ?></td>
                    <td><?= htmlspecialchars($v['group_name'] ?? '') ?></td>
                    <td><?= htmlspecialchars($v['rdp_nickname'] ?? '') ?></td>
                    <td><?= $v['current_ip'] ?? $v['ip_address'] ?? '-' ?></td>
                    <td>
                        <span class="status-pill <?= $isOnline ? 'pill-online' : 'pill-offline' ?>">
                            <?= $isOnline ? 'ONLINE' : 'OFFLINE' ?>
                        </span>
                    </td>
                    <td>
                        <?php if(!empty($v['earnapp_token'])): ?>
                            <div class="earnapp-wrap">
                                <span class="token-text"><?= htmlspecialchars($v['earnapp_token']) ?></span>
                                <button class="copy-btn" onclick="copyToken('https://earnapp.com/dashboard/link/<?= htmlspecialchars($v['earnapp_token']) ?>', this)">
                                    <i class="fas fa-copy"></i>
                                </button>
                            </div>
                        <?php else: ?>
                            <span class="text-danger">Missing</span>
                        <?php endif; ?>
                    </td>
                    <td style="color: <?= $isOnline ? '#00c853' : '#f44336' ?>; font-weight:bold;">
                        <?= $isOnline ? 'YES' : 'NO' ?>
                    </td>
                    <td style="color: #888;"><?= timeAgo($v['last_heartbeat'] ?? '') ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
 


