<?php
if (!isset($conn)) {
    die('DB connection missing');
}

date_default_timezone_set('Asia/Kolkata');

$res = $conn->query("SELECT COUNT(*) AS c FROM vms");
$stats['total_vms'] = $res ? (int)$res->fetch_assoc()['c'] : 0;

$res = $conn->query("SELECT COUNT(*) AS c FROM vms WHERE last_heartbeat IS NOT NULL AND last_heartbeat >= NOW() - INTERVAL 5 MINUTE");
$stats['online_vms'] = $res ? (int)$res->fetch_assoc()['c'] : 0;

$res = $conn->query("SELECT COUNT(*) AS c FROM vms WHERE LOWER(status) LIKE '%running%'");
$stats['app_online'] = $res ? (int)$res->fetch_assoc()['c'] : 0;

$today_res = $conn->query("
    SELECT IFNULL(SUM(GREATEST(0, t.today_max - IFNULL(y.prev_max, 0))), 0) AS total
    FROM (
        SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS today_max
        FROM earnapp_history WHERE DATE(recorded_at) = CURDATE()
        GROUP BY earnapp_token
    ) t
    LEFT JOIN (
        SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS prev_max
        FROM earnapp_history WHERE DATE(recorded_at) = CURDATE() - INTERVAL 1 DAY
        GROUP BY earnapp_token
    ) y ON y.earnapp_token = t.earnapp_token
");
$stats['earning_today'] = $today_res ? (float)($today_res->fetch_assoc()['total'] ?? 0) : 0;

$yesterday_res = $conn->query("
    SELECT IFNULL(SUM(GREATEST(0, y.yest_max - IFNULL(p.prev_max, 0))), 0) AS total
    FROM (
        SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS yest_max
        FROM earnapp_history WHERE DATE(recorded_at) = CURDATE() - INTERVAL 1 DAY
        GROUP BY earnapp_token
    ) y
    LEFT JOIN (
        SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS prev_max
        FROM earnapp_history WHERE DATE(recorded_at) = CURDATE() - INTERVAL 2 DAY
        GROUP BY earnapp_token
    ) p ON p.earnapp_token = y.earnapp_token
");
$stats['earning_yesterday'] = $yesterday_res ? (float)($yesterday_res->fetch_assoc()['total'] ?? 0) : 0;

$week_res = $conn->query("
    SELECT IFNULL(SUM(daily_earned), 0) AS total
    FROM (
        SELECT t.earnapp_token, t.dt,
               GREATEST(0, t.day_max - IFNULL(p.prev_day_max, 0)) AS daily_earned
        FROM (
            SELECT earnapp_token, DATE(recorded_at) AS dt,
                   MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS day_max
            FROM earnapp_history
            WHERE DATE(recorded_at) BETWEEN CURDATE() - INTERVAL 5 DAY AND CURDATE()
            GROUP BY earnapp_token, DATE(recorded_at)
        ) t
        LEFT JOIN (
            SELECT earnapp_token, DATE(recorded_at) AS dt,
                   MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS prev_day_max
            FROM earnapp_history
            GROUP BY earnapp_token, DATE(recorded_at)
        ) p ON p.earnapp_token = t.earnapp_token AND p.dt = DATE_SUB(t.dt, INTERVAL 1 DAY)
    ) x
");
$stats['earning_week'] = $week_res ? (float)($week_res->fetch_assoc()['total'] ?? 0) : 0;

$month_start = date('Y-m-01');
$month_res = $conn->query("
    SELECT IFNULL(SUM(daily_earned), 0) AS total
    FROM (
        SELECT t.earnapp_token, t.dt,
               GREATEST(0, t.day_max - IFNULL(p.prev_day_max, 0)) AS daily_earned
        FROM (
            SELECT earnapp_token, DATE(recorded_at) AS dt,
                   MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS day_max
            FROM earnapp_history
            WHERE DATE(recorded_at) BETWEEN '$month_start' AND CURDATE()
            GROUP BY earnapp_token, DATE(recorded_at)
        ) t
        LEFT JOIN (
            SELECT earnapp_token, DATE(recorded_at) AS dt,
                   MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) AS prev_day_max
            FROM earnapp_history
            GROUP BY earnapp_token, DATE(recorded_at)
        ) p ON p.earnapp_token = t.earnapp_token AND p.dt = DATE_SUB(t.dt, INTERVAL 1 DAY)
    ) x
");
$stats['earning_month'] = $month_res ? (float)($month_res->fetch_assoc()['total'] ?? 0) : 0;

$res = $conn->query("SELECT IFNULL(SUM(balance),0) AS total FROM vms");
$total_lifetime = $res ? (float)$res->fetch_assoc()['total'] : 0;
?>

<div class="row mb-4 flex-nowrap">
    <div class="col">
        <div class="card bg-dark text-white p-3 border-danger text-center">
            <h6>Total VMs</h6>
            <h3><?= $stats['total_vms'] ?></h3>
        </div>
    </div>
    <div class="col">
        <div class="card bg-dark text-white p-3 border-success text-center">
            <h6>Online</h6>
            <h3><?= $stats['online_vms'] ?></h3>
        </div>
    </div>
    <div class="col">
        <div class="card bg-dark text-white p-3 border-success text-center">
            <h6>App Online</h6>
            <h3><?= $stats['app_online'] ?></h3>
        </div>
    </div>
    <div class="col">
        <div class="card bg-dark text-white p-3 border-warning text-center">
            <h6>Today</h6>
            <h3>$<?= number_format($stats['earning_today'],2) ?></h3>
        </div>
    </div>
    <div class="col">
        <div class="card bg-dark text-white p-3 border-secondary text-center">
            <h6>Yesterday</h6>
            <h3>$<?= number_format($stats['earning_yesterday'],2) ?></h3>
        </div>
    </div>
    <div class="col">
        <div class="card bg-dark text-white p-3 border-primary text-center">
            <h6>This Week</h6>
            <h3>$<?= number_format($stats['earning_week'],2) ?></h3>
        </div>
    </div>
    <div class="col">
        <div class="card bg-dark text-white p-3 border-info text-center">
            <h6>This Month</h6>
            <h3>$<?= number_format($stats['earning_month'],2) ?></h3>
        </div>
    </div>
</div>