<?php
if (!isAdmin()) {
    echo '<div class="container-fluid px-4 py-4"><div class="alert alert-danger">Access denied. Admin only.</div></div>';
    return;
}

$allGroups = [];
$gRes = $conn->query("SELECT id, name FROM `groups` ORDER BY name");
while ($row = $gRes->fetch_assoc()) $allGroups[] = $row;

$allUsers = [];
$uRes = $conn->query("SELECT id, username, role, email, is_active, last_login, created_at FROM users ORDER BY created_at DESC");
while ($row = $uRes->fetch_assoc()) $allUsers[] = $row;

foreach ($allUsers as &$u) {
    $uid = (int)$u['id'];
    if ($u['role'] === 'admin') {
        // Admin sees all groups
        $gRes2 = $conn->query("SELECT id FROM `groups`");
    } else {
        // User sees only their owned groups
        $gRes2 = $conn->query("SELECT id FROM `groups` WHERE owner_user_id=" . $uid);
    }
    $u['group_ids'] = array();
    if ($gRes2) { while ($ugRow = $gRes2->fetch_assoc()) $u['group_ids'][] = (int)$ugRow['id']; }
    $gidStr = implode(',', array_merge($u['group_ids'], array(0)));
    $vmRes = $conn->query("SELECT COUNT(*) as c FROM vms v JOIN rdps r ON r.id=v.rdp_id WHERE r.group_id IN (" . $gidStr . ")");
    $u['vm_count'] = $vmRes ? (int)$vmRes->fetch_assoc()['c'] : 0;
    // Count owned groups
    $u['group_count'] = count($u['group_ids']);
}
unset($u);
?>

<div class="container-fluid px-4 py-3">

<div class="d-flex align-items-center justify-content-between mb-4">
    <div>
        <h4 class="mb-0 fw-bold" style="color:#9b4dff">User Management</h4>
        <small class="text-muted">Manage users and their group access</small>
    </div>
    <button class="btn btn-sm" style="background:linear-gradient(135deg,#9b4dff,#6a00ff);color:#fff;border:none;padding:8px 18px;border-radius:8px;" onclick="openAddUser()">
        <i class="fa fa-plus me-2"></i>Add User
    </button>
</div>

<div class="row mb-3 g-3">
    <div class="col-md-3">
        <div class="card border-0 text-center py-3" style="background:#0b0c10;border:1px solid rgba(155,77,255,.3)!important;border-radius:12px;">
            <div style="font-size:28px;font-weight:700;color:#9b4dff"><?= count($allUsers) ?></div>
            <div class="text-muted small">Total Users</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 text-center py-3" style="background:#0b0c10;border:1px solid rgba(0,229,255,.3)!important;border-radius:12px;">
            <div style="font-size:28px;font-weight:700;color:#00e5ff"><?= count(array_filter($allUsers, function($u){ return $u['is_active']; })) ?></div>
            <div class="text-muted small">Active Users</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 text-center py-3" style="background:#0b0c10;border:1px solid rgba(0,255,102,.3)!important;border-radius:12px;">
            <div style="font-size:28px;font-weight:700;color:#00ff66"><?= count($allGroups) ?></div>
            <div class="text-muted small">Total Groups</div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="card border-0 text-center py-3" style="background:#0b0c10;border:1px solid rgba(255,179,0,.3)!important;border-radius:12px;">
            <div style="font-size:28px;font-weight:700;color:#ffb300"><?= count(array_filter($allUsers, function($u){ return $u['role'] === 'admin'; })) ?></div>
            <div class="text-muted small">Admins</div>
        </div>
    </div>
</div>

<div class="table-responsive" style="background:#0b0c10;border:1px solid rgba(255,255,255,.08);border-radius:12px;overflow:hidden;">
    <table class="table table-dark table-hover mb-0" style="font-size:14px;">
        <thead style="background:rgba(155,77,255,.15);border-bottom:1px solid rgba(155,77,255,.4);">
            <tr>
                <th class="py-3 ps-4">User</th>
                <th>Role</th>
                <th>Email</th>
                <th>VMs</th>
                <th>Owned Groups</th>
                <th>Status</th>
                <th>Last Login</th>
                <th class="pe-4">Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($allUsers as $u): ?>
        <?php
        // group names not needed - showing count only
        ?>
        <tr style="border-bottom:1px solid rgba(255,255,255,.05);" id="user-row-<?= $u['id'] ?>">
            <td class="ps-4 py-3">
                <div class="d-flex align-items-center gap-2">
                    <div style="width:36px;height:36px;border-radius:50%;background:linear-gradient(135deg,#9b4dff,#00e5ff);display:flex;align-items:center;justify-content:center;font-weight:700;font-size:14px;flex-shrink:0;">
                        <?= strtoupper(substr($u['username'], 0, 1)) ?>
                    </div>
                    <div>
                        <div class="fw-semibold"><?= htmlspecialchars($u['username']) ?></div>
                        <div class="text-muted" style="font-size:11px;">ID: <?= $u['id'] ?></div>
                    </div>
                </div>
            </td>
            <td class="py-3">
                <span class="badge" style="font-size:11px;padding:4px 10px;border-radius:20px;<?= $u['role']==='admin' ? 'background:rgba(155,77,255,.2);color:#9b4dff;border:1px solid rgba(155,77,255,.4)' : 'background:rgba(0,229,255,.1);color:#00e5ff;border:1px solid rgba(0,229,255,.3)' ?>">
                    <?= strtoupper($u['role']) ?>
                </span>
            </td>
            <td class="py-3 text-muted"><?= htmlspecialchars($u['email'] ?: '—') ?></td>
            <td class="py-3">
                <span style="color:#00ff66;font-weight:600;"><?= $u['vm_count'] ?></span>
            </td>
            <td class="py-3">
                <?php if ($u['role'] === 'admin'): ?>
                    <span style="color:#9b4dff;font-weight:600;font-size:13px;">All <span class="text-muted" style="font-size:11px;">(admin)</span></span>
                <?php elseif ($u['group_count'] > 0): ?>
                    <span style="color:#00ff66;font-weight:600;"><?= $u['group_count'] ?></span> <span class="text-muted" style="font-size:11px;">groups</span>
                <?php else: ?>
                    <span class="text-muted" style="font-size:12px;">None yet</span>
                <?php endif; ?>
            </td>
            <td class="py-3">
                <span style="<?= $u['is_active'] ? 'color:#00ff66' : 'color:#ff003c' ?>">
                    <i class="fa fa-circle" style="font-size:8px;margin-right:4px;"></i>
                    <?= $u['is_active'] ? 'Active' : 'Inactive' ?>
                </span>
            </td>
            <td class="py-3 text-muted" style="font-size:12px;">
                <?= $u['last_login'] ? date('d/m/y H:i', strtotime($u['last_login'])) : 'Never' ?>
            </td>
            <td class="pe-4 py-3">
                <div class="d-flex gap-1">
                    <?php if ($u['role'] !== 'admin'): ?>
                    <button class="btn btn-sm" style="background:rgba(155,77,255,.15);color:#9b4dff;border:1px solid rgba(155,77,255,.4);border-radius:6px;padding:4px 8px;" title="Manage Permissions" onclick="openPermissions(<?= $u['id'] ?>, '<?= htmlspecialchars(addslashes($u['username'])) ?>')">
                        <i class="fa fa-shield-halved"></i>
                    </button>
                    <?php endif; ?>
                    <button class="btn btn-sm" style="background:rgba(255,179,0,.1);color:#ffb300;border:1px solid rgba(255,179,0,.3);border-radius:6px;padding:4px 8px;" title="Change Password" onclick="openChangePass(<?= $u['id'] ?>, '<?= htmlspecialchars(addslashes($u['username'])) ?>')">
                        <i class="fa fa-key"></i>
                    </button>
                    <?php if ($u['id'] != $_SESSION['user_id']): ?>
                    <button class="btn btn-sm" style="background:rgba(255,179,0,.1);color:#ffb300;border:1px solid rgba(255,179,0,.3);border-radius:6px;padding:4px 8px;" title="<?= $u['is_active'] ? 'Deactivate' : 'Activate' ?>" onclick="toggleUser(<?= $u['id'] ?>)">
                        <i class="fa <?= $u['is_active'] ? 'fa-ban' : 'fa-check' ?>"></i>
                    </button>
                    <button class="btn btn-sm" style="background:rgba(255,0,60,.1);color:#ff003c;border:1px solid rgba(255,0,60,.3);border-radius:6px;padding:4px 8px;" title="Delete" onclick="deleteUser(<?= $u['id'] ?>, '<?= htmlspecialchars(addslashes($u['username'])) ?>')">
                        <i class="fa fa-trash"></i>
                    </button>
                    <?php endif; ?>
                </div>
            </td>
        </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>

</div>

<div id="uOverlay" style="display:none;position:fixed;inset:0;background:rgba(0,0,0,.7);z-index:9000;" onclick="closeUModals()"></div>

<div id="modal-add-user" style="display:none;position:fixed;inset:0;z-index:9001;align-items:center;justify-content:center;">
    <div style="background:#0b0c10;border:1px solid rgba(155,77,255,.5);border-radius:16px;padding:28px;width:420px;max-width:95%;">
        <h5 class="mb-4 fw-bold" style="color:#9b4dff"><i class="fa fa-user-plus me-2"></i>Add New User</h5>
        <div class="mb-3">
            <label class="small text-muted mb-1">Username *</label>
            <input id="nu_username" class="form-control" style="background:#050507;border:1px solid rgba(255,255,255,.15);color:#fff;" placeholder="min 3 chars">
        </div>
        <div class="mb-3">
            <label class="small text-muted mb-1">Password *</label>
            <input id="nu_password" type="password" class="form-control" style="background:#050507;border:1px solid rgba(255,255,255,.15);color:#fff;" placeholder="min 6 chars">
        </div>
        <div class="mb-3">
            <label class="small text-muted mb-1">Email</label>
            <input id="nu_email" type="email" class="form-control" style="background:#050507;border:1px solid rgba(255,255,255,.15);color:#fff;" placeholder="optional">
        </div>
        <div class="mb-4">
            <label class="small text-muted mb-1">Role</label>
            <select id="nu_role" class="form-select" style="background:#050507;border:1px solid rgba(255,255,255,.15);color:#fff;">
                <option value="user">User</option>
                <option value="admin">Admin</option>
            </select>
        </div>
        <div class="d-flex gap-2">
            <button class="btn flex-fill" style="background:linear-gradient(135deg,#9b4dff,#6a00ff);color:#fff;border:none;border-radius:8px;" onclick="submitAddUser()">Create User</button>
            <button class="btn flex-fill" style="background:rgba(255,255,255,.08);color:#aaa;border:1px solid rgba(255,255,255,.1);border-radius:8px;" onclick="closeUModals()">Cancel</button>
        </div>
    </div>
</div>

<div id="modal-group-assign" style="display:none;position:fixed;inset:0;z-index:9001;align-items:center;justify-content:center;">
    <div style="background:#0b0c10;border:1px solid rgba(0,229,255,.4);border-radius:16px;padding:28px;width:460px;max-width:95%;">
        <h5 class="mb-1 fw-bold" style="color:#00e5ff"><i class="fa fa-layer-group me-2"></i>Assign Groups</h5>
        <p class="text-muted small mb-4" id="assign_username_label"></p>
        <input type="hidden" id="assign_user_id">
        <div id="group_checkboxes" class="mb-4" style="max-height:280px;overflow-y:auto;">
            <?php foreach ($allGroups as $g): ?>
            <label class="d-flex align-items-center gap-2 p-2 rounded mb-1" style="cursor:pointer;background:rgba(255,255,255,.03);border:1px solid rgba(255,255,255,.06);">
                <input type="checkbox" class="grp-chk" value="<?= $g['id'] ?>" style="width:16px;height:16px;accent-color:#00e5ff;">
                <span><?= htmlspecialchars($g['name']) ?></span>
            </label>
            <?php endforeach; ?>
        </div>
        <div class="d-flex gap-2">
            <button class="btn flex-fill" style="background:linear-gradient(135deg,#00e5ff,#0099bb);color:#000;font-weight:700;border:none;border-radius:8px;" onclick="submitGroupAssign()">Save Access</button>
            <button class="btn flex-fill" style="background:rgba(255,255,255,.08);color:#aaa;border:1px solid rgba(255,255,255,.1);border-radius:8px;" onclick="closeUModals()">Cancel</button>
        </div>
    </div>
</div>

<div id="modal-change-pass" style="display:none;position:fixed;inset:0;z-index:9001;align-items:center;justify-content:center;">
    <div style="background:#0b0c10;border:1px solid rgba(255,179,0,.4);border-radius:16px;padding:28px;width:380px;max-width:95%;">
        <h5 class="mb-1 fw-bold" style="color:#ffb300"><i class="fa fa-key me-2"></i>Change Password</h5>
        <p class="text-muted small mb-4" id="cp_username_label"></p>
        <input type="hidden" id="cp_user_id">
        <div class="mb-4">
            <label class="small text-muted mb-1">New Password</label>
            <input id="cp_password" type="password" class="form-control" style="background:#050507;border:1px solid rgba(255,255,255,.15);color:#fff;" placeholder="min 6 chars">
        </div>
        <div class="d-flex gap-2">
            <button class="btn flex-fill" style="background:linear-gradient(135deg,#ffb300,#ff7700);color:#000;font-weight:700;border:none;border-radius:8px;" onclick="submitChangePass()">Update Password</button>
            <button class="btn flex-fill" style="background:rgba(255,255,255,.08);color:#aaa;border:1px solid rgba(255,255,255,.1);border-radius:8px;" onclick="closeUModals()">Cancel</button>
        </div>
    </div>
</div>

<script>
const UA = {
    async api(action, data) {
        const r = await fetch('pages/api.php?action=' + action, {
            method: 'POST',
            headers: {'Content-Type': 'application/json'},
            body: JSON.stringify(data)
        });
        return r.json();
    },

    notify(msg, ok = true) {
        const el = document.createElement('div');
        el.textContent = msg;
        el.style.cssText = `position:fixed;top:20px;right:20px;z-index:99999;padding:12px 20px;border-radius:10px;font-weight:600;font-size:14px;backdrop-filter:blur(10px);${ok ? 'background:rgba(0,255,102,.2);color:#00ff66;border:1px solid rgba(0,255,102,.4)' : 'background:rgba(255,0,60,.2);color:#ff003c;border:1px solid rgba(255,0,60,.4)'}`;
        document.body.appendChild(el);
        setTimeout(() => el.remove(), 3000);
    }
};

function openAddUser() {
    document.getElementById('uOverlay').style.display = 'block';
    document.getElementById('modal-add-user').style.display = 'flex';
}

function openGroupAssign(userId, username, currentGids) {
    document.getElementById('assign_user_id').value = userId;
    document.getElementById('assign_username_label').textContent = 'User: ' + username;
    document.querySelectorAll('.grp-chk').forEach(cb => {
        cb.checked = currentGids.includes(parseInt(cb.value));
    });
    document.getElementById('uOverlay').style.display = 'block';
    document.getElementById('modal-group-assign').style.display = 'flex';
}

function openChangePass(userId, username) {
    document.getElementById('cp_user_id').value = userId;
    document.getElementById('cp_username_label').textContent = 'User: ' + username;
    document.getElementById('cp_password').value = '';
    document.getElementById('uOverlay').style.display = 'block';
    document.getElementById('modal-change-pass').style.display = 'flex';
}

function closeUModals() {
    document.getElementById('uOverlay').style.display = 'none';
    ['modal-add-user','modal-group-assign','modal-change-pass','modal-permissions'].forEach(id => document.getElementById(id).style.display = 'none');
}

async function submitAddUser() {
    const username = document.getElementById('nu_username').value.trim();
    const password = document.getElementById('nu_password').value.trim();
    const email    = document.getElementById('nu_email').value.trim();
    const role     = document.getElementById('nu_role').value;
    const res = await UA.api('user_add', { username, password, email, role });
    if (res.success) { UA.notify('User created!'); setTimeout(() => location.reload(), 800); }
    else UA.notify(res.error || 'Failed', false);
}

async function submitGroupAssign() {
    const userId   = parseInt(document.getElementById('assign_user_id').value);
    const groupIds = [...document.querySelectorAll('.grp-chk:checked')].map(cb => parseInt(cb.value));
    const res = await UA.api('user_assign_groups', { user_id: userId, group_ids: groupIds });
    if (res.success) { UA.notify('Access updated!'); setTimeout(() => location.reload(), 800); }
    else UA.notify('Failed', false);
}

async function submitChangePass() {
    const userId   = parseInt(document.getElementById('cp_user_id').value);
    const password = document.getElementById('cp_password').value.trim();
    const res = await UA.api('user_change_password', { user_id: userId, password });
    if (res.success) { UA.notify('Password updated!'); closeUModals(); }
    else UA.notify(res.error || 'Failed', false);
}

async function toggleUser(userId) {
    const res = await UA.api('user_toggle', { user_id: userId });
    if (res.success) location.reload();
    else UA.notify('Failed', false);
}

async function deleteUser(userId, username) {
    if (!confirm('Delete user "' + username + '"? This cannot be undone.')) return;
    const res = await UA.api('user_delete', { user_id: userId });
    if (res.success) {
        document.getElementById('user-row-' + userId)?.remove();
        UA.notify('User deleted');
    } else UA.notify(res.error || 'Failed', false);
}
async function openPermissions(userId, username) {
    document.getElementById('perm_user_id').value    = userId;
    document.getElementById('perm_username').textContent = 'User: ' + username;

    // Reset all toggles
    document.querySelectorAll('.perm-toggle').forEach(cb => cb.checked = false);
    document.getElementById('perm_loading').style.display = 'block';
    document.getElementById('perm_body').style.display    = 'none';

    document.getElementById('uOverlay').style.display          = 'block';
    document.getElementById('modal-permissions').style.display = 'flex';

    const res = await UA.api('user_get_permissions', { user_id: userId });
    document.getElementById('perm_loading').style.display = 'none';
    document.getElementById('perm_body').style.display    = 'block';
    if (res.success) {
        const perms = res.permissions || {};
        document.querySelectorAll('.perm-toggle').forEach(cb => {
            cb.checked = !!perms[cb.dataset.key];
        });
    }
}

async function submitPermissions() {
    const userId = parseInt(document.getElementById('perm_user_id').value);
    const perms  = {};
    document.querySelectorAll('.perm-toggle').forEach(cb => { perms[cb.dataset.key] = cb.checked; });
    const res = await UA.api('user_save_permissions', { user_id: userId, permissions: perms });
    if (res.success) { UA.notify('Permissions saved!'); closeUModals(); }
    else UA.notify(res.error || 'Failed to save', false);
}

function togglePermGroup(groupKey, state) {
    document.querySelectorAll('.perm-toggle[data-group="' + groupKey + '"]').forEach(cb => cb.checked = state);
}
</script>

<!-- Permissions Modal -->
<div id="modal-permissions" style="display:none;position:fixed;inset:0;z-index:9001;align-items:center;justify-content:center;">
    <div style="background:#0b0c10;border:1px solid rgba(155,77,255,.5);border-radius:16px;padding:28px;width:520px;max-width:95%;max-height:85vh;overflow-y:auto;">
        <h5 class="mb-1 fw-bold" style="color:#9b4dff"><i class="fa fa-shield-halved me-2"></i>Manage Permissions</h5>
        <p class="text-muted small mb-3" id="perm_username"></p>
        <input type="hidden" id="perm_user_id">

        <div id="perm_loading" class="text-center py-4 text-muted">
            <i class="fa fa-spinner fa-spin me-2"></i>Loading permissions...
        </div>
        <div id="perm_body" style="display:none;">

        <?php
        require_once __DIR__ . '/../includes/permissions.php';
        $groups = [
            'group'   => ['label' => '🗂️ Group Management',   'color' => '#00e5ff'],
            'rdp'     => ['label' => '🖥️ RDP Management',     'color' => '#9b4dff'],
            'vm'      => ['label' => '⚙️ VM Management',      'color' => '#00ff66'],
            'earnings'=> ['label' => '💰 Earnings & Reports',  'color' => '#ffb300'],
            'other'   => ['label' => '⚡ Other Access',         'color' => '#ff7700'],
        ];
        // Group perms by category
        $grouped = [];
        foreach (PERM_LABELS as $key => [$cat, $lbl]) {
            $grouped[$cat][] = ['key' => $key, 'label' => $lbl];
        }
        foreach ($groups as $gk => $gMeta):
            $color = $gMeta['color'];
        ?>
        <div class="mb-3" style="background:rgba(255,255,255,.03);border:1px solid rgba(255,255,255,.07);border-radius:10px;padding:14px;">
            <div class="d-flex align-items-center justify-content-between mb-2">
                <div style="font-size:13px;font-weight:700;color:<?= $color ?>;"><?= $gMeta['label'] ?></div>
                <div class="d-flex gap-1">
                    <button type="button" class="btn btn-sm" style="font-size:10px;padding:2px 8px;background:rgba(0,255,102,.1);color:#00ff66;border:1px solid rgba(0,255,102,.25);border-radius:20px;" onclick="togglePermGroup('<?= $gk ?>',true)">All On</button>
                    <button type="button" class="btn btn-sm" style="font-size:10px;padding:2px 8px;background:rgba(255,0,60,.1);color:#ff003c;border:1px solid rgba(255,0,60,.25);border-radius:20px;" onclick="togglePermGroup('<?= $gk ?>',false)">All Off</button>
                </div>
            </div>
            <div class="row g-2">
            <?php foreach ($grouped[$gk] ?? [] as $perm): ?>
                <div class="col-6">
                    <label style="display:flex;align-items:center;gap:8px;cursor:pointer;padding:6px 10px;background:rgba(255,255,255,.03);border:1px solid rgba(255,255,255,.06);border-radius:8px;font-size:12px;">
                        <input type="checkbox" class="perm-toggle" data-key="<?= $perm['key'] ?>" data-group="<?= $gk ?>" style="width:15px;height:15px;accent-color:<?= $color ?>;">
                        <span style="color:#ccc;"><?= htmlspecialchars($perm['label']) ?></span>
                    </label>
                </div>
            <?php endforeach; ?>
            </div>
        </div>
        <?php endforeach; ?>

        </div><!-- /perm_body -->

        <div class="d-flex gap-2 mt-3">
            <button class="btn flex-fill" style="background:linear-gradient(135deg,#9b4dff,#6a00ff);color:#fff;border:none;border-radius:8px;font-weight:600;" onclick="submitPermissions()">
                <i class="fa fa-save me-2"></i>Save Permissions
            </button>
            <button class="btn flex-fill" style="background:rgba(255,255,255,.08);color:#aaa;border:1px solid rgba(255,255,255,.1);border-radius:8px;" onclick="closeUModals()">Cancel</button>
        </div>
    </div>
</div>