<?php
ini_set('display_errors', 0);
error_reporting(E_ALL);
header('Content-Type: application/json');
require_once __DIR__ . '/db.php';

$json = file_get_contents('php://input');
$data = json_decode($json, true);

if (!$data || empty($data['vm_id'])) {
    echo json_encode(["status" => "error", "msg" => "vm_id missing"]);
    exit;
}

$vmId        = (int)$data['vm_id'];
$group       = trim($data['group_name']   ?? '');
$rdp         = trim($data['rdp_nickname'] ?? '');
$isHeartbeat = isset($data['action']) && $data['action'] === 'heartbeat';
$bal         = (isset($data['balance']) && $data['balance'] !== null && $data['balance'] !== '')
    ? (float)preg_replace('/[^0-9.]/', '', (string)$data['balance'])
    : null;
$traf        = (float)preg_replace('/[^0-9.]/', '', (string)($data['traffic'] ?? '0'));
$stat        = trim($data['status'] ?? '');
$token       = trim($data['earnapp_token'] ?? '');
$ip          = trim($data['ip_address'] ?? $_SERVER['REMOTE_ADDR']);

$allowed = ['Running', 'Blocked', 'Paused', 'Connecting', 'Offline'];
if (!in_array($stat, $allowed, true)) $stat = null;
if ($stat === 'Connecting') $stat = 'Offline';

$chk = $conn->prepare("SELECT id FROM vms WHERE id = ? LIMIT 1");
$chk->bind_param("i", $vmId);
$chk->execute();
$chk->bind_result($existId);
$exists = $chk->fetch();
$chk->close();

if (!$exists) {
    echo json_encode(["status" => "error", "msg" => "VM not registered"]);
    exit;
}

if (!$isHeartbeat && !empty($token)) {
    $tc = $conn->prepare("SELECT id FROM vms WHERE earnapp_token = ? AND id != ? LIMIT 1");
    $tc->bind_param("si", $token, $vmId);
    $tc->execute();
    $tc->bind_result($oldId);
    if ($tc->fetch() && $oldId) {
        $conn->query("UPDATE vms SET earnapp_token=NULL, status='Offline' WHERE id=" . (int)$oldId);
        $conn->query("INSERT INTO vm_commands (vm_id, command, status, created_at) VALUES (" . (int)$oldId . ", 'stop_agent', 'pending', UTC_TIMESTAMP())");
    }
    $tc->close();
}

$updates = ["current_ip = ?", "last_heartbeat = NOW()"];
$params  = [$ip];
$types   = 's';

if (!$isHeartbeat) {
    $updates[] = "traffic = ?";
    $params[]  = $traf;
    $types    .= 'd';

    if (!empty($token)) {
        $updates[] = "earnapp_token = ?";
        $params[]  = $token;
        $types    .= 's';
    }

    if ($stat !== null) {
        $updates[] = "status = ?";
        $params[]  = $stat;
        $types    .= 's';
    }

    if ($bal !== null) {
        $updates[] = "balance = ?";
        $params[]  = $bal;
        $types    .= 'd';
    }
}

$sql  = "UPDATE vms SET " . implode(", ", $updates) . " WHERE id = ?";
$params[] = $vmId;
$types   .= 'i';

$stmt = $conn->prepare($sql);
$stmt->bind_param($types, ...$params);

if ($stmt->execute()) {
    if (!$isHeartbeat && in_array($stat, ['Running', 'Blocked', 'Paused'], true)) {
        date_default_timezone_set('Asia/Kolkata');
        $earningDate = date('Y-m-d');

        $ins = $conn->prepare("
            INSERT INTO earnapp_history
            (vm_id, earning_date, group_name, rdp_nickname, balance, ip_address, earnapp_token, status)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?)
            ON DUPLICATE KEY UPDATE
                balance     = VALUES(balance),
                status      = VALUES(status),
                ip_address  = VALUES(ip_address),
                recorded_at = CURRENT_TIMESTAMP
        ");
        $balHist = $bal !== null ? (string)$bal : '0';
        $ins->bind_param("isssssss", $vmId, $earningDate, $group, $rdp, $balHist, $ip, $token, $stat);
        $ins->execute();
        $ins->close();
    }
    echo json_encode(["status" => "success"]);
} else {
    echo json_encode(["status" => "error", "msg" => "Database update failed"]);
}

$stmt->close();
$conn->close();
