<?php
if (session_status() === PHP_SESSION_NONE) session_start();
require_once __DIR__ . '/../db.php';

if (empty($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$username  = $_SESSION['username'] ?? '';
$role      = $_SESSION['role'] ?? 'user';
$avatarUrl = "assets/css/../../../assets/img/default-avatar.png";

$stmt = $conn->prepare("SELECT avatar FROM users WHERE id=? LIMIT 1");
$stmt->bind_param("i", $_SESSION['user_id']);
$stmt->execute();
$stmt->bind_result($avatar);
$stmt->fetch();
$stmt->close();

if (!empty($avatar)) {
    $avatarUrl = "uploads/avatars/" . $avatar;
}
?>

<header class="topbar">
    <div class="user-box" style="display:flex;align-items:center;gap:12px;">
        <div class="avatar" style="background-image:url('<?= htmlspecialchars($avatarUrl) ?>');width:38px;height:38px;border-radius:50%;border:2px solid <?= $role==='admin' ? '#9b4dff' : '#00e5ff' ?>;background-color:#111;background-size:cover;background-position:center;flex-shrink:0;"></div>
        <div>
            <div class="username" style="font-weight:600;line-height:1.2;"><?= htmlspecialchars($username) ?></div>
            <span style="font-size:10px;font-weight:700;padding:1px 7px;border-radius:20px;letter-spacing:.5px;<?= $role==='admin' ? 'background:rgba(155,77,255,.2);color:#9b4dff;border:1px solid rgba(155,77,255,.4)' : 'background:rgba(0,229,255,.1);color:#00e5ff;border:1px solid rgba(0,229,255,.3)' ?>"><?= strtoupper($role) ?></span>
        </div>
    </div>
    <div class="brand-title" style="font-family:Orbitron,sans-serif;letter-spacing:2px;">BDMA APP</div>
    <div style="display:flex;align-items:center;gap:8px;">
        <a href="logout.php" style="color:#666;text-decoration:none;font-size:12px;padding:6px 12px;border:1px solid rgba(255,255,255,.1);border-radius:8px;transition:all .2s;" onmouseover="this.style.color='#ff003c';this.style.borderColor='rgba(255,0,60,.4)'" onmouseout="this.style.color='#666';this.style.borderColor='rgba(255,255,255,.1)'">
            <i class="fa fa-right-from-bracket me-1"></i> Logout
        </a>
    </div>
</header>
