<?php
if (!isset($conn)) { die('DB connection missing'); }

date_default_timezone_set('Asia/Kolkata');

$_ts        = getVmData($conn);
$_ts_vmList = $_ts['vmIdList'];
$_ts_tokList= $_ts['tokenList'];
$_month_s   = date('Y-m-01');

$res = $conn->query("SELECT COUNT(*) AS c FROM vms WHERE id IN ($_ts_vmList)");
$stats['total_vms'] = $res ? (int)$res->fetch_assoc()['c'] : 0;

$res = $conn->query("SELECT COUNT(*) AS c FROM vms WHERE id IN ($_ts_vmList) AND last_heartbeat IS NOT NULL AND last_heartbeat >= NOW() - INTERVAL 5 MINUTE");
$stats['online_vms'] = $res ? (int)$res->fetch_assoc()['c'] : 0;

$res = $conn->query("SELECT COUNT(*) AS c FROM vms WHERE id IN ($_ts_vmList) AND LOWER(status) LIKE '%running%'");
$stats['app_online'] = $res ? (int)$res->fetch_assoc()['c'] : 0;

$r = $conn->query("
    SELECT IFNULL(SUM(GREATEST(0, t.t - IFNULL(y.y,0))),0) v
    FROM (SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) t FROM earnapp_history WHERE DATE(recorded_at)=CURDATE() AND earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token) t
    LEFT JOIN (SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) y FROM earnapp_history WHERE DATE(recorded_at)=CURDATE()-INTERVAL 1 DAY AND earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token) y ON y.earnapp_token=t.earnapp_token
");
$stats['earning_today'] = $r ? (float)($r->fetch_assoc()['v'] ?? 0) : 0;

$r = $conn->query("
    SELECT IFNULL(SUM(GREATEST(0, y.y - IFNULL(p.p,0))),0) v
    FROM (SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) y FROM earnapp_history WHERE DATE(recorded_at)=CURDATE()-INTERVAL 1 DAY AND earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token) y
    LEFT JOIN (SELECT earnapp_token, MAX(COALESCE(redeem_balance, CAST(balance AS DECIMAL(10,4)))) p FROM earnapp_history WHERE DATE(recorded_at)=CURDATE()-INTERVAL 2 DAY AND earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token) p ON p.earnapp_token=y.earnapp_token
");
$stats['earning_yesterday'] = $r ? (float)($r->fetch_assoc()['v'] ?? 0) : 0;

$r = $conn->query("
    SELECT IFNULL(SUM(daily_earned),0) v FROM (
        SELECT t.earnapp_token, GREATEST(0, t.m - IFNULL(p.m,0)) daily_earned
        FROM (SELECT earnapp_token, DATE(recorded_at) dt, MAX(COALESCE(redeem_balance,CAST(balance AS DECIMAL(10,4)))) m FROM earnapp_history WHERE DATE(recorded_at) BETWEEN CURDATE()-INTERVAL 6 DAY AND CURDATE() AND earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token, DATE(recorded_at)) t
        LEFT JOIN (SELECT earnapp_token, DATE(recorded_at) dt, MAX(COALESCE(redeem_balance,CAST(balance AS DECIMAL(10,4)))) m FROM earnapp_history WHERE earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token, DATE(recorded_at)) p ON p.earnapp_token=t.earnapp_token AND p.dt=DATE_SUB(t.dt, INTERVAL 1 DAY)
    ) x
");
$stats['earning_week'] = $r ? (float)($r->fetch_assoc()['v'] ?? 0) : 0;

$r = $conn->query("
    SELECT IFNULL(SUM(daily_earned),0) v FROM (
        SELECT t.earnapp_token, GREATEST(0, t.m - IFNULL(p.m,0)) daily_earned
        FROM (SELECT earnapp_token, DATE(recorded_at) dt, MAX(COALESCE(redeem_balance,CAST(balance AS DECIMAL(10,4)))) m FROM earnapp_history WHERE DATE(recorded_at) BETWEEN '$_month_s' AND CURDATE() AND earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token, DATE(recorded_at)) t
        LEFT JOIN (SELECT earnapp_token, DATE(recorded_at) dt, MAX(COALESCE(redeem_balance,CAST(balance AS DECIMAL(10,4)))) m FROM earnapp_history WHERE earnapp_token IN ($_ts_tokList) GROUP BY earnapp_token, DATE(recorded_at)) p ON p.earnapp_token=t.earnapp_token AND p.dt=DATE_SUB(t.dt, INTERVAL 1 DAY)
    ) x
");
$stats['earning_month'] = $r ? (float)($r->fetch_assoc()['v'] ?? 0) : 0;
?>

<div class="row mb-4 flex-nowrap">
    <div class="col"><div class="card bg-dark text-white p-3 border-danger text-center"><h6>Total VMs</h6><h3><?= $stats['total_vms'] ?></h3></div></div>
    <div class="col"><div class="card bg-dark text-white p-3 border-success text-center"><h6>Online</h6><h3><?= $stats['online_vms'] ?></h3></div></div>
    <div class="col"><div class="card bg-dark text-white p-3 border-success text-center"><h6>App Online</h6><h3><?= $stats['app_online'] ?></h3></div></div>
    <div class="col"><div class="card bg-dark text-white p-3 border-warning text-center"><h6>Today</h6><h3>$<?= number_format($stats['earning_today'],2) ?></h3></div></div>
    <div class="col"><div class="card bg-dark text-white p-3 border-secondary text-center"><h6>Yesterday</h6><h3>$<?= number_format($stats['earning_yesterday'],2) ?></h3></div></div>
    <div class="col"><div class="card bg-dark text-white p-3 border-primary text-center"><h6>This Week</h6><h3>$<?= number_format($stats['earning_week'],2) ?></h3></div></div>
    <div class="col"><div class="card bg-dark text-white p-3 border-info text-center"><h6>This Month</h6><h3>$<?= number_format($stats['earning_month'],2) ?></h3></div></div>
</div>