<?php
session_start();
require_once __DIR__ . '/db.php';

ini_set('display_errors', 0);
error_reporting(E_ALL);

$error = '';

if (isset($_GET['err'])) {
    if ($_GET['err'] === 'deactivated') $error = 'Your account has been deactivated. Contact admin.';
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    $stmt = $conn->prepare("SELECT id, username, avatar, password, role, is_active FROM users WHERE username=? LIMIT 1");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($id, $username_db, $avatar, $password_db, $role, $is_active);
    $stmt->fetch();
    $stmt->close();

    if ($id) {
        if (!$is_active) {
            $error = 'Your account is deactivated. Contact admin.';
        } else {
            if (strlen($password_db) < 60 && $password === $password_db) {
                $newHash = password_hash($password, PASSWORD_DEFAULT);
                $up = $conn->prepare("UPDATE users SET password=? WHERE id=?");
                $up->bind_param("si", $newHash, $id);
                $up->execute();
                $password_db = $newHash;
            }

            if (password_verify($password, $password_db)) {
                $_SESSION['user_id']  = $id;
                $_SESSION['username'] = $username_db;
                $_SESSION['avatar']   = $avatar ?? '';
                $_SESSION['role']     = $role;

                $conn->query("UPDATE users SET last_login=NOW() WHERE id=$id");

                session_write_close();
                header('Location: index.php?page=dashboard');
                exit;
            } else {
                $error = 'Invalid username or password';
            }
        }
    } else {
        $error = 'Invalid username or password';
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>BDMA — Login</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
*{box-sizing:border-box;}
body{min-height:100vh;background:radial-gradient(circle at top,#1a0030,#000);display:flex;align-items:center;justify-content:center;color:#fff;padding:15px;}
.login-box{width:100%;max-width:380px;background:#050507;border:1px solid rgba(155,77,255,.5);border-radius:16px;padding:36px;box-shadow:0 0 40px rgba(155,77,255,.25);}
.brand{text-align:center;margin-bottom:30px;}
.brand-icon{font-size:48px;margin-bottom:8px;}
.brand-name{font-size:24px;font-weight:800;letter-spacing:3px;background:linear-gradient(135deg,#9b4dff,#00e5ff);-webkit-background-clip:text;-webkit-text-fill-color:transparent;}
.brand-sub{font-size:11px;color:#666;letter-spacing:2px;}
.form-control{background:#0b0c10;border:1px solid rgba(255,255,255,.15);color:#fff;height:46px;border-radius:10px;transition:border-color .2s;}
.form-control:focus{border-color:#9b4dff;box-shadow:0 0 0 2px rgba(155,77,255,.2);background:#0b0c10;color:#fff;}
.form-control::placeholder{color:#555;}
.btn-login{background:linear-gradient(135deg,#9b4dff,#6a00ff);border:none;height:46px;border-radius:10px;font-weight:700;letter-spacing:1px;transition:opacity .2s;}
.btn-login:hover{opacity:.85;}
.error{background:rgba(255,0,60,.1);border:1px solid rgba(255,0,60,.4);padding:10px 14px;border-radius:8px;text-align:center;margin-bottom:18px;color:#ff6b6b;font-size:13px;}
label{font-size:12px;color:#888;letter-spacing:.5px;margin-bottom:6px;display:block;}
</style>
</head>
<body>
<div class="login-box">
    <div class="brand">
        <div class="brand-icon">🛡️</div>
        <div class="brand-name">BDMA</div>
        <div class="brand-sub">VM WATCHDOG SYSTEM</div>
    </div>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="mb-3">
            <label>USERNAME</label>
            <input type="text" name="username" class="form-control" placeholder="Enter username" required autocomplete="username">
        </div>
        <div class="mb-4">
            <label>PASSWORD</label>
            <input type="password" name="password" class="form-control" placeholder="Enter password" required autocomplete="current-password">
        </div>
        <button type="submit" class="btn btn-login w-100 text-white">AUTHENTICATE</button>
    </form>
</div>
</body>
</html>
