<?php
session_start();
require_once __DIR__ . '/db.php';

ini_set('display_errors', 1);
error_reporting(E_ALL);

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $username = trim($_POST['username'] ?? '');
    $password = trim($_POST['password'] ?? '');

    $stmt = $conn->prepare(
        "SELECT id, username, avatar, `password`
         FROM users
         WHERE username = ?
         LIMIT 1"
    );
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $stmt->bind_result($id, $username_db, $avatar, $password_db);
    $stmt->fetch();

    if ($id) {

        if (strlen($password_db) < 60 && $password === $password_db) {
            $newHash = password_hash($password, PASSWORD_DEFAULT);
            $up = $conn->prepare("UPDATE users SET `password`=? WHERE id=?");
            $up->bind_param("si", $newHash, $id);
            $up->execute();
            $password_db = $newHash;
        }

        if (password_verify($password, $password_db)) {
            $_SESSION['user_id']   = $id;
            $_SESSION['username'] = $username_db;
            $_SESSION['avatar']   = $avatar ?? '';
            session_write_close();
            header("Location: index.php?page=dashboard");
            exit;
        }
    }

    $error = "Invalid username or password";
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Login</title>

<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">

<style>
body{
    min-height:100vh;
    background:radial-gradient(circle at top,#240000,#000);
    display:flex;
    align-items:center;
    justify-content:center;
    color:#fff;
    padding:15px;
}
.login-box{
    width:100%;
    max-width:380px;
    background:#000;
    border:1px solid #b30000;
    border-radius:12px;
    padding:30px;
    box-shadow:0 0 30px rgba(255,0,0,.3);
}
.form-control{
    background:#000;
    border:1px solid #333;
    color:#fff;
    height:46px;
}
.form-control:focus{
    border-color:#b30000;
    box-shadow:none;
}
.btn-login{
    background:linear-gradient(135deg,#b30000,#ff0000);
    border:none;
    height:46px;
}
.error{
    background:#330000;
    border:1px solid #ff0000;
    padding:8px;
    border-radius:6px;
    text-align:center;
    margin-bottom:15px;
    color:#ff6b6b;
    font-size:14px;
}
@media (max-width:576px){
    .login-box{
        padding:22px;
    }
    h2{
        font-size:20px;
    }
}
</style>
</head>

<body>

<div class="login-box">
    <h2 class="text-center mb-4">ACCESS</h2>

    <?php if ($error): ?>
        <div class="error"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form method="post">
        <div class="mb-3">
            <input type="text" name="username" class="form-control" placeholder="USERNAME" required>
        </div>

        <div class="mb-4">
            <input type="password" name="password" class="form-control" placeholder="PASSWORD" required>
        </div>

        <button type="submit" class="btn btn-login w-100">
            AUTHENTICATE
        </button>
    </form>
</div>

</body>
</html>