<?php
require_once __DIR__ . '/../../../db.php';
$db = $conn;

$vm_id = (int)basename($_SERVER['REQUEST_URI']);
$input = json_decode(file_get_contents('php://input'), true);

if (!$vm_id) {
    http_response_code(400);
    exit;
}

$ip      = $input['current_ip'] ?? null;
$running = (int)($input['earnapp_running'] ?? 0);
$auto    = (int)($input['earnapp_autostart'] ?? 0);
$paused  = (int)($input['earnapp_paused'] ?? 0);
$balance = (float)($input['balance'] ?? 0);

$db->query("
    UPDATE vms SET
        current_ip        = ".($ip ? "'".$db->real_escape_string($ip)."'" : "NULL").",
        earnapp_running   = $running,
        earnapp_autostart = $auto,
        earnapp_paused    = $paused,
        balance           = $balance,
        last_seen         = NOW(),
        status            = 'online'
    WHERE id = $vm_id
");

@file_put_contents(
    __DIR__.'/../../../runtime/live_'.$vm_id.'.json',
    json_encode([
        'current_ip'=>$ip,
        'earnapp_running'=>$running,
        'earnapp_autostart'=>$auto,
        'earnapp_paused'=>$paused,
        'balance'=>$balance,
        'last_seen'=>time()
    ])
);

echo json_encode(['success'=>true]);
