<?php
ini_set('display_errors', 0);
ini_set('display_startup_errors', 0);
error_reporting(0);

header('Content-Type: application/json');

require_once __DIR__ . '/../db.php';

// Sirf $conn use karein, $db nahi
if (!isset($conn) || $conn->connect_error) {
    echo json_encode(['success' => false, 'error' => 'Database connection failed']);
    exit;
}

date_default_timezone_set('Asia/Kolkata');

$input = json_decode(file_get_contents('php://input'), true);
if (json_last_error() !== JSON_ERROR_NONE) {
    $input = [];
}
$action = $_GET['action'] ?? ($input['action'] ?? '');

if (empty($action)) {
    echo json_encode(['success' => false, 'error' => 'No action specified']);
    exit;
}

function nowUtc() {
    return gmdate('Y-m-d H:i:s');
}

define('FREEZE_LIMIT', 6);
define('HARD_FREEZE_LIMIT', 20);

switch ($action) {

    case 'send_command':

        $vmId = (int)($input['vm_id'] ?? 0);
        $cmd  = strtolower(trim($input['command'] ?? ''));

        if ($vmId <= 0 || $cmd === '') {
            echo json_encode(['success' => false]);
            exit;
        }

        $stmt = $conn->prepare("
            INSERT INTO vm_commands (vm_id, command, status, created_at)
            VALUES (?, ?, 'pending', UTC_TIMESTAMP())
        ");

        $stmt->bind_param("is", $vmId, $cmd);

        if ($stmt->execute()) {
            echo json_encode(['success' => true]);
        } else {
            echo json_encode(['success' => false]);
        }
        exit;


    case 'vm_ping':

        $vmId = (int)($input['vm_id'] ?? 0);

        if ($vmId > 0) {
            $stmt = $conn->prepare("UPDATE vms SET last_seen = UTC_TIMESTAMP() WHERE id = ?");
            $stmt->bind_param("i", $vmId);
            $stmt->execute();
        }

        echo json_encode(['success' => true]);
        exit;


case 'load_all':
    $groups = []; 
    $res = $conn->query("
        SELECT 
        g.id AS g_id,
        g.name AS g_name,
        r.id AS r_id,
        r.name AS r_name,
        v.id AS v_id,
        v.unit_id,
        v.current_ip,
        v.last_heartbeat,
        v.balance,
        v.traffic,
        v.status
    FROM groups g
    LEFT JOIN rdps r ON g.id = r.group_id
    LEFT JOIN vms v ON r.id = v.rdp_id
    ORDER BY g.name, r.name, v.unit_id

    ");

    while ($row = $res->fetch_assoc()) {
        $gId = $row['g_id'];
        if (!isset($groups[$gId])) {
            $groups[$gId] = ['id' => $gId, 'name' => $row['g_name'], 'rdps' => []];
        }
        if ($row['r_id']) {
            if (!isset($groups[$gId]['rdps'][$row['r_id']])) {
                $groups[$gId]['rdps'][$row['r_id']] = ['id' => $row['r_id'], 'name' => $row['r_name'], 'vms' => []];
            }
            if ($row['v_id']) {
                $groups[$gId]['rdps'][$row['r_id']]['vms'][] = [
                    'id' => (int)$row['v_id'],
                    'name' => $row['unit_id'],
                    'current_ip' => $row['current_ip'],
                    'last_seen' => $row['last_heartbeat'],
                    'balance' => $row['balance'],
                    'traffic' => $row['traffic'],
                    'status' => $row['status']
                ];
            }
        }
    }
    $final = [];
    foreach ($groups as $g) {
        $g['rdps'] = array_values($g['rdps']);
        $final[] = $g;
    }
    echo json_encode(['success' => true, 'data' => ['data' => $final, 'server_time' => date('Y-m-d H:i:s')]]);
    exit;
    
    
case 'update_balance':
    $stmt = $conn->prepare("
        UPDATE earnapp_nodes
        SET balance=?, traffic=?, status=?, last_updated=UTC_TIMESTAMP()
        WHERE vm_id=?
    ");
    $stmt->bind_param(
        "sssi",
        $input['balance'],
        $input['traffic'],
        $input['status'],
        $input['vm_id']
    );
    $stmt->execute();
    echo json_encode(['ok'=>true]);
    exit;

case 'fetch_command':

    $vmId = (int)($_GET['vm_id'] ?? 0);

    if ($vmId <= 0) {
        echo json_encode(null);
        exit;
    }

    $res = $conn->query("
        SELECT id, command
        FROM vm_commands
        WHERE vm_id = $vmId
          AND status = 'pending'
        ORDER BY id ASC
        LIMIT 1
    ");

    if ($res && $row = $res->fetch_assoc()) {
        $conn->query("
            UPDATE vm_commands
            SET status='sent'
            WHERE id=".$row['id']."
        ");

        echo json_encode([
            'id' => (int)$row['id'],
            'action' => $row['command']
        ]);
        exit;
    }

    echo json_encode(null);
    exit;


case 'register':
    $groupName = $input['group_name'];
    $rdpName   = $input['rdp_nickname'];
    $g = $conn->query("SELECT id FROM groups WHERE name='".$conn->real_escape_string($groupName)."' LIMIT 1")->fetch_assoc();
    $r = $conn->query("SELECT id FROM rdps WHERE name='".$conn->real_escape_string($rdpName)."' LIMIT 1")->fetch_assoc();
    if (!$g || !$r) {
        echo json_encode(['error'=>'group_or_rdp_missing']);
        exit;
    }
    $stmt = $conn->prepare("
        INSERT INTO vms (unit_id, group_id, rdp_id, group_name, rdp_nickname, current_ip, status, last_seen)
        VALUES (?, ?, ?, ?, ?, ?, 'online', UTC_TIMESTAMP())
        ON DUPLICATE KEY UPDATE
        current_ip=VALUES(current_ip),
        status='online',
        last_seen=UTC_TIMESTAMP()
    ");
    $stmt->bind_param("siisss", $input['unit_id'], $g['id'], $r['id'], $groupName, $rdpName, $input['assigned_ip']);
    $stmt->execute();
    echo json_encode(['vm_id' => $conn->insert_id]);
    exit;

case 'delete_vms':

    $ids = $input['ids'] ?? [];

    if (!is_array($ids) || empty($ids)) {
        echo json_encode(['success'=>false]);
        exit;
    }

    $idList = implode(',', array_map('intval', $ids));
    $conn->query("DELETE FROM vms WHERE id IN ($idList)");

    echo json_encode(['success'=>true]);
    exit;

case 'delete_rdps':

    $ids = $input['ids'] ?? [];

    if (!is_array($ids) || empty($ids)) {
        echo json_encode(['success'=>false]);
        exit;
    }

    $idList = implode(',', array_map('intval', $ids));

    $conn->query("
        DELETE FROM vms
        WHERE rdp_id IN ($idList)
           OR (rdp_id IS NULL AND rdp_nickname IN (
                SELECT name FROM rdps WHERE id IN ($idList)
              ))
    ");

    $conn->query("DELETE FROM rdps WHERE id IN ($idList)");

    echo json_encode(['success'=>true]);
    exit;

case 'delete_vm_commands':

    $data = json_decode(file_get_contents('php://input'), true);
    $ids = $data['ids'] ?? [];

    if (!is_array($ids) || empty($ids)) {
        echo json_encode(['success' => false]);
        exit;
    }

    $ids = array_map('intval', $ids);
    $idList = implode(',', $ids);

    $conn->query("DELETE FROM vm_commands WHERE id IN ($idList)");

    echo json_encode(['success' => true]);
    exit;


case 'delete_groups':

    $ids = $input['ids'] ?? [];

    if (!is_array($ids) || empty($ids)) {
        echo json_encode(['success'=>false]);
        exit;
    }

    $idList = implode(',', array_map('intval', $ids));

    $conn->query("
        DELETE FROM vms
        WHERE group_id IN ($idList)
           OR (group_id IS NULL AND group_name IN (
                SELECT name FROM groups WHERE id IN ($idList)
              ))
    ");

    $conn->query("DELETE FROM rdps WHERE group_id IN ($idList)");
    $conn->query("DELETE FROM groups WHERE id IN ($idList)");

    echo json_encode(['success'=>true]);
    exit;

case 'heartbeat':
    if (empty($input['vm_id'])) {
        echo json_encode(['success'=>false]);
        exit;
    }
    $vmId = (int)$input['vm_id'];
    $ip   = $input['ip_address'] ?? null;
    $conn->query("
        UPDATE vms 
        SET last_seen = UTC_TIMESTAMP(), 
            current_ip = " . ($ip ? "'" . $conn->real_escape_string($ip) . "'" : "current_ip") . "
        WHERE id = $vmId
    ");
    echo json_encode(['success'=>true]);
    exit;


case 'ack_command':
    $id    = (int)($_GET['id'] ?? 0);
    $vm_id = (int)($_GET['vm_id'] ?? 0);

    if ($id <= 0 || $vm_id <= 0) {
        echo json_encode(['ok'=>false]);
        exit;
    }

    $conn->query("
        UPDATE vm_commands
        SET status='done',
            completed_at=UTC_TIMESTAMP()
        WHERE id=$id AND vm_id=$vm_id
    ");

    echo json_encode(['ok'=>true]);
    exit;


case 'command_result':

    $stmt = $conn->prepare("
        UPDATE vm_commands
        SET status='done',
            result=CONCAT('[', ?, '] ', ?),
            completed_at=UTC_TIMESTAMP()
        WHERE id=?
    ");

    $success = !empty($input['success']) ? 'OK' : 'FAIL';

    $stmt->bind_param(
        "ssi",
        $success,
        $input['message'],
        $input['command_id']
    );

    $stmt->execute();
    echo json_encode(['ok'=>true]);
    exit;

case 'add_group':

    $stmt = $conn->prepare("INSERT INTO groups (name) VALUES (?)");
    $stmt->bind_param("s", $input['name']);
    $stmt->execute();
    echo json_encode(['success'=>true]);
    exit;

case 'add_rdp':

    $stmt = $conn->prepare("
        INSERT INTO rdps (name, group_id, ip, username)
        VALUES (?, ?, ?, ?)
    ");

    $stmt->bind_param(
        "siss",
        $input['name'],
        $input['group_id'],
        $input['ip'],
        $input['username']
    );

    $stmt->execute();
    echo json_encode(['success'=>true]);
    exit;


    
  
  
case 'add_vm':
    $rdpId = (int)($input['rdp_id'] ?? 0);
    $vmName = trim($input['unit_id'] ?? '');

    if ($rdpId <= 0 || $vmName === '') {
        echo json_encode(['success' => false, 'error' => 'Input missing']);
        exit;
    }

    // Pehle next available ID find karein
    $res = $conn->query("SELECT MAX(id) as max_id FROM vms");
    $row = $res->fetch_assoc();
    $nextId = (int)$row['max_id'] + 1;

    $r_res = $conn->query("SELECT name, group_id FROM rdps WHERE id = $rdpId");
    
    if (!$r_res || $r_res->num_rows === 0) {
        echo json_encode(['success' => false, 'error' => 'RDP ID not found']);
        exit;
    }

    $r = $r_res->fetch_assoc();

    $g_res = $conn->query("SELECT name FROM groups WHERE id = " . (int)$r['group_id']);
    $gName = ($g_res && $g_res->num_rows > 0) ? $g_res->fetch_assoc()['name'] : 'Default';

    // Explicitly ID specify karein
    $stmt = $conn->prepare("INSERT INTO vms (id, unit_id, group_id, rdp_id, group_name, rdp_nickname, status, last_heartbeat) VALUES (?, ?, ?, ?, ?, ?, 'offline', NULL)");
    
    if (!$stmt) {
        echo json_encode(['success' => false, 'error' => $conn->error]);
        exit;
    }

    $gid = (int)$r['group_id'];
    $stmt->bind_param("isiiss", $nextId, $vmName, $gid, $rdpId, $gName, $r['name']);

    $ok = $stmt->execute();
    echo json_encode(['success' => $ok, 'vm_id' => $ok ? $nextId : null, 'error' => $ok ? null : $stmt->error]);
    exit;


case 'send_all_by_unit':

    $cmd = strtolower(trim($input['command'] ?? ''));

    if ($cmd === '') {
        echo json_encode(['success' => false]);
        exit;
    }

    $stmt = $conn->prepare("
        INSERT INTO vm_commands (vm_id, command, status, created_at)
        SELECT id, ?, 'pending', UTC_TIMESTAMP()
        FROM vms
        WHERE unit_id IS NOT NULL
    ");

    $stmt->bind_param("s", $cmd);
    $stmt->execute();

    echo json_encode([
        'success' => $stmt->affected_rows > 0
    ]);
    exit;


case 'send_global_command':

    $cmd = 'fetch_balance_global';

    $stmt = $conn->prepare("
        INSERT INTO vm_commands (vm_id, command, status, created_at)
        SELECT id, ?, 'pending', UTC_TIMESTAMP()
        FROM vms
        WHERE unit_id IS NOT NULL
    ");

    $stmt->bind_param("s", $cmd);
    $stmt->execute();

    echo json_encode([
        'success' => $stmt->affected_rows > 0
    ]);
    exit;



default:
    echo json_encode(['success' => false, 'error' => 'Invalid action']);
    exit;
}

$conn->close();
?>