<?php

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$page = $_GET['page'] ?? 'dashboard';
$allowed = ['dashboard','reports','settings','users'];

if (!in_array($page, $allowed)) {
    $page = 'dashboard';
}
?>


<?php include 'includes/head.php'; ?>
<body>

<?php include 'includes/sidebar.php'; ?>

<div class="main">
    <?php include 'includes/topbar.php'; ?>
    <?php include "pages/{$page}.php"; ?>
</div>

<?php include 'includes/footer.php'; ?>

<script>
function togglePwd(id, el){
  const input = document.getElementById(id);
  const icon = el.querySelector('i');

  if(input.type === "password"){
    input.type = "text";
    icon.classList.replace("fa-eye","fa-eye-slash");
  }else{
    input.type = "password";
    icon.classList.replace("fa-eye-slash","fa-eye");
  }
}
</script>


</body>
</html>
