<?php
include '../db.php';

// Set headers for CSV download
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename=applications.csv');

$output = fopen('php://output', 'w');

// Write column headers
fputcsv($output, ['ID', 'Full Name', 'Email', 'Phone', 'Plan', 'Type', 'Created At', 'Price (£)']);

// Check if selected IDs provided
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['ids'])) {
    $ids = explode(',', $_POST['ids']);
    $ids = array_map('intval', $ids); // sanitize

    $idList = implode(',', $ids);
    $sql = "SELECT id, full_name, email, phone, plan, type, created_at, total_price FROM applications WHERE id IN ($idList)";
} else {
    // Bulk mode
    $sql = "SELECT id, full_name, email, phone, plan, type, created_at, total_price FROM applications ORDER BY id DESC";
}

$result = $conn->query($sql);

while ($row = $result->fetch_assoc()) {
    fputcsv($output, [
        $row['id'],
        $row['full_name'],
        $row['email'],
        $row['phone'],
        $row['plan'],
        $row['type'],
        $row['created_at'],
        '£' . $row['total_price']
    ]);
}

fclose($output);
exit;
?>
