<?php
include '../db.php';
$conn->set_charset("utf8mb4");
session_start();

if(!isset($_SESSION['user_id'])){
    header('Location: login.php');
    exit;
}

// Example user info (you can replace this with actual query if needed)
$user = ['full_name' => 'User']; 

$user_id = $_SESSION['user_id'];
$current_amount = "";

// ✅ Fetch existing amount (if any)
$result = $conn->query("SELECT amount FROM booklate_upgrade WHERE user_id = '$user_id' LIMIT 1");
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $current_amount = $row['amount'];
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $amount = $conn->real_escape_string($_POST['amount']);

    // ✅ Update if exists, else insert new
    $check = $conn->query("SELECT id FROM booklate_upgrade WHERE user_id = '$user_id' LIMIT 1");
    if ($check && $check->num_rows > 0) {
        $sql = "UPDATE booklate_upgrade SET amount='$amount' WHERE user_id='$user_id'";
    } else {
        $sql = "INSERT INTO booklate_upgrade (user_id, amount) VALUES ('$user_id', '$amount')";
    }

    if ($conn->query($sql)) {
        $message = "Saved successfully!";
        $current_amount = $amount; // show updated value instantly
    } else {
        $message = "Error: " . $conn->error;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Booklate Upgrade</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
    .circle-name { 
        width: 40px; height: 40px; 
        border-radius: 50%; background: #007bff; 
        color: #fff; text-align: center; line-height: 40px; 
        font-weight: bold; margin-right: 10px;
    }
</style>
</head>

<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
        <?php include 'menu.php'; ?>
    </div>

    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button">
                <button class="btn toggle_btn" type="button"></button>
            </div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?php echo strtoupper(substr($user['full_name'], 0, 2)); ?></span>
                    <div class="user_name"><h4><?php echo htmlspecialchars($user['full_name']); ?></h4></div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
            <div class="body_wrap">
                <h3>Booklate Upgrade</h3>
                <div class="inner-wrapper">
                    
                    <?php if (isset($message)) { ?>
                        <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
                    <?php } ?>

                   <form method="POST" class="form-wrapper">
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="form-label">Amount (£)</label>
            <div class="input-group">
                <span class="input-group-text">£</span>
                <input 
                    type="number" 
                    step="1" 
                    name="amount" 
                    placeholder="Enter amount in pounds" 
                    class="form-control" 
                    required 
                    value="<?php echo htmlspecialchars(rtrim(rtrim($current_amount, '0'), '.')); ?>">
            </div>
        </div>
    </div>
    <button type="submit" class="btn btn-primary">Save Upgrade</button>
</form>

                </div>
            </div>
        </div>
    </div>
</div>
</body>
</html>
