<?php
include '../db.php';
$conn->set_charset("utf8mb4");
session_start();
if(!isset($_SESSION['user_id'])){
    header('Location: login.php');
    exit;
}

// Fetch user details
$user_id = $_SESSION['user_id'];
$user_result = $conn->query("SELECT * FROM users WHERE id=$user_id");
$user = $user_result->fetch_assoc();

// --- Validity and Promo Handling (No changes needed here) ---
// Handle Validity
if(isset($_POST['add_validity'])){
    $validity_name = trim($_POST['validity']); // Renamed from $validity for clarity

    // Fetch all price values, default to 0.0 if not provided or invalid
    $booklet_only_hard = isset($_POST['booklet_only_hard']) && is_numeric($_POST['booklet_only_hard']) && $_POST['booklet_only_hard'] >= 0 ? floatval($_POST['booklet_only_hard']) : 0.0;
    $booklet_card_hard = isset($_POST['booklet_card_hard']) && is_numeric($_POST['booklet_card_hard']) && $_POST['booklet_card_hard'] >= 0 ? floatval($_POST['booklet_card_hard']) : 0.0;
    $booklet_card_soft = isset($_POST['booklet_card_soft']) && is_numeric($_POST['booklet_card_soft']) && $_POST['booklet_card_soft'] >= 0 ? floatval($_POST['booklet_card_soft']) : 0.0;
    $booklet_only_soft = isset($_POST['booklet_only_soft']) && is_numeric($_POST['booklet_only_soft']) && $_POST['booklet_only_soft'] >= 0 ? floatval($_POST['booklet_only_soft']) : 0.0;

    $errorValidity = ''; // Initialize error message

    // Basic validation: Name is required.
    if(empty($validity_name)) {
        $errorValidity = "Validity Name is required.";
    }
    // Optional: Add more validation if needed, e.g., ensure at least one price is positive.

    if (empty($errorValidity)) {
        // Use prepared statement for insertion, including all price columns
        $stmt = $conn->prepare("
            INSERT INTO addon_validity
            (validity, booklet_only_hard, booklet_card_hard, booklet_card_soft, booklet_only_soft, created_at)
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        // Bind parameters: s = string, d = double
        // validity (string), booklet_only_hard (double), booklet_card_hard (double), booklet_card_soft (double), booklet_only_soft (double), created_at (string)
        $currentTimestamp = date('Y-m-d H:i:s');
        $stmt->bind_param("sdddds", $validity_name, $booklet_only_hard, $booklet_card_hard, $booklet_card_soft, $booklet_only_soft, $currentTimestamp);

        if ($stmt->execute()) {
            $successValidity = "Validity option added successfully!";
            // Redirect to prevent form resubmission
            header("Location: " . $_SERVER['PHP_SELF']);
            exit();
        } else {
            $errorValidity = "Database error: " . $stmt->error;
        }
        $stmt->close(); // Close statement
    }
    // If $errorValidity is set, it will be displayed from the existing if block
}

// Handle Promo
if(isset($_POST['add_promo'])){
    $promo = trim($_POST['promo']);
    $discount_type = $_POST['discount_type'];
    $discount_value = floatval($_POST['discount_value']);
    // Check if expiry_date is empty before assigning, otherwise assign NULL
    $expiry_date = !empty($_POST['expiry_date']) ? $_POST['expiry_date'] : NULL;
    // Check if usage_limit is empty before assigning, otherwise assign NULL
    $usage_limit = !empty($_POST['usage_limit']) ? intval($_POST['usage_limit']) : NULL;

    // Basic validation
    if($promo && $discount_value > 0 && ($discount_type === 'percent' || $discount_type === 'fixed')){
        $stmt = $conn->prepare("INSERT INTO addon_promo
            (promo, discount_type, discount_value, expiry_date, usage_limit)
            VALUES (?, ?, ?, ?, ?)");
        // Assuming promo is string 's', discount_type is string 's', discount_value is double 'd', expiry_date is string 's', usage_limit is integer 'i'
        // If expiry_date is NULL, bind_param needs 's' and we pass NULL directly or an empty string depending on DB expectations for NULL date strings. Let's assume 's' works with NULL.
        $stmt->bind_param("ssdsi", $promo, $discount_type, $discount_value, $expiry_date, $usage_limit);
         if($stmt->execute()){
            $successPromo = "Promo added successfully!";
             // Redirect to prevent form resubmission
             header("Location: " . $_SERVER['PHP_SELF']);
             exit();
        } else {
             $errorPromo = "Database error: " . $stmt->error;
        }
    } else {
        $errorPromo = "Enter valid promo details (Code, positive Discount Value, valid Type).";
    }
}

// Delete actions
if(isset($_GET['delete_addon'])) $conn->query("DELETE FROM addon_products WHERE id=".intval($_GET['delete_addon']));
if(isset($_GET['delete_validity'])) $conn->query("DELETE FROM addon_validity WHERE id=".intval($_GET['delete_validity']));
if(isset($_GET['delete_promo'])) $conn->query("DELETE FROM addon_promo WHERE id=".intval($_GET['delete_promo']));

// Fetch all for display (no changes needed here)
$addons = $conn->query("SELECT * FROM addon_products ORDER BY id DESC");
$validities = $conn->query("SELECT * FROM addon_validity ORDER BY id DESC");
$promos = $conn->query("SELECT * FROM addon_promo ORDER BY id DESC");

$uploadDir = 'uploads/';

// --- MODIFIED Add-on Handling ---
if (isset($_POST['add_addon'])) {
    $type = $_POST['addon_type'] ?? '';
    $currentTimestamp = date('Y-m-d H:i:s');
    $image_name = ''; // Default to empty
    $errorAddon = ''; // Initialize error message for this section
    $successAddon = ''; // Initialize success message for this section

    // Handle image upload validation first
    if (isset($_FILES['addon_image']) && $_FILES['addon_image']['error'] === UPLOAD_ERR_OK) {
        $fileTmpName = $_FILES['addon_image']['tmp_name'];
        $originalName = $_FILES['addon_image']['name'];
        $fileSize = $_FILES['addon_image']['size'];

        $ext = strtolower(pathinfo($originalName, PATHINFO_EXTENSION));
        $allowed = ['jpg','jpeg','png','gif','svg'];

        if (!in_array($ext, $allowed)) {
            $errorAddon = "Invalid file type. Allowed: jpg, jpeg, png, gif, svg.";
        } elseif ($fileSize > 300*1024) {
            $errorAddon = "File size exceeds 300 KB limit.";
        } else {
            // Generate unique name and move file only if validation passes
            $image_name = uniqid($type . '_', true) . '.' . $ext;
            if (!move_uploaded_file($fileTmpName, $uploadDir . $image_name)) {
                $errorAddon = "Failed to upload the image.";
                $image_name = ''; // Ensure image_name is reset if upload fails
            }
        }
    } elseif (isset($_FILES['addon_image']) && $_FILES['addon_image']['error'] !== UPLOAD_ERR_NO_FILE) {
        // Handle other upload errors (e.g., partial upload, no temp dir)
        $errorAddon = "An error occurred during image upload.";
    }

    // Proceed to database insertion only if no prior errors and a type is selected
    if (empty($errorAddon) && !empty($type)) {

        $stmt = null; // Ensure $stmt is initialized

        if ($type === 'hard') {
            $name = trim($_POST['addon_name']);
            // Use isset checks and default to 0.0 if not provided
            $price_card = isset($_POST['addon_hard_booklet_card_price']) ? floatval($_POST['addon_hard_booklet_card_price']) : 0.0;
            $price_only = isset($_POST['addon_hard_booklet_only_price']) ? floatval($_POST['addon_hard_booklet_only_price']) : 0.0;

            // Validate input for hard copy
            if ($name && ($price_card > 0 || $price_only > 0)) {
                $stmt = $conn->prepare("
                    INSERT INTO addon_products
                    (name, addon_hard_booklet_card_price, addon_hard_booklet_only_price, hard_image, created_at)
                    VALUES (?, ?, ?, ?, ?)
                ");
                // Bind parameters specific to hard copy. Other columns (soft) remain NULL by default.
                $stmt->bind_param("sddss", $name, $price_card, $price_only, $image_name, $currentTimestamp);

                // *** EXECUTE MOVED INSIDE THE BLOCK ***
                if ($stmt->execute()) {
                    $successAddon = "Hard copy add-on added successfully!";
                    // Redirect immediately after successful insertion
                    header("Location: " . $_SERVER['PHP_SELF']);
                    exit();
                } else {
                    $errorAddon = "Database error (Hard Copy Insert): " . $stmt->error;
                }
            } else {
                // Set error if validation fails for hard copy
                $errorAddon = "Please enter a valid Hard Copy name and at least one positive price.";
            }

        } elseif ($type === 'soft') {
            $name = trim($_POST['addon_soft_product_name']);
            // Use isset checks and default to 0.0 if not provided
            $price_card = isset($_POST['addon_soft_booklet_card_price']) ? floatval($_POST['addon_soft_booklet_card_price']) : 0.0;
            $price_only = isset($_POST['addon_soft_booklet_only_price']) ? floatval($_POST['addon_soft_booklet_only_price']) : 0.0;

            // Validate input for soft copy
            if ($name && ($price_card > 0 || $price_only > 0)) {
                $stmt = $conn->prepare("
                    INSERT INTO addon_products
                    (addon_soft_product_name, addon_soft_booklet_card_price, addon_soft_booklet_only_price, soft_image, created_at)
                    VALUES (?, ?, ?, ?, ?)
                ");
                 // Bind parameters specific to soft copy. Other columns (hard) remain NULL by default.
                $stmt->bind_param("sddss", $name, $price_card, $price_only, $image_name, $currentTimestamp);

                // *** EXECUTE MOVED INSIDE THE BLOCK ***
                if ($stmt->execute()) {
                    $successAddon = "Soft copy add-on added successfully!";
                    // Redirect immediately after successful insertion
                    header("Location: " . $_SERVER['PHP_SELF']);
                    exit();
                } else {
                    $errorAddon = "Database error (Soft Copy Insert): " . $stmt->error;
                }
            } else {
                 // Set error if validation fails for soft copy
                $errorAddon = "Please enter a valid Soft Copy name and at least one positive price.";
            }
        } else {
             // Catch invalid type if somehow not caught by 'required' or JS
             $errorAddon = "Invalid add-on type selected.";
        }

        // Close the statement if it was prepared and used
        if ($stmt) {
            $stmt->close();
        }

    } elseif (empty($type)) {
        // Handle case where type wasn't selected but form submitted
        $errorAddon = "Please select an Add-on Type.";
    }
    // Note: If image upload failed ($errorAddon is set), the code won't reach DB insertion.
    // If DB insertion fails, $errorAddon will be set within the if/elseif blocks.
    // If everything succeeds, the redirect happens and this part is not reached.
}


// Function to get image for display (No changes needed)
function getAddonImage($row, $type) {
    $img = ($type === 'hard') ? $row['hard_image'] : $row['soft_image'];
    if(!empty($img) && file_exists("uploads/$img")) return $img;
    return null;
}

?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Addon Options Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
.circle-name { width: 40px; height: 40px; border-radius: 50%; background: #007bff; color: #fff; text-align: center; line-height: 40px; font-weight: bold; margin-right: 10px; }
.table-style img { max-height: 50px; }
/* Added basic styling for form elements for better layout */
#addonForm div, #addonForm select, #addonForm input[type=file], #addonForm button {
    margin-bottom: 10px;
}
#hardFields, #softFields {
    display: flex; /* Use flex for horizontal layout if desired */
    flex-direction: column; /* Stack fields vertically */
    gap: 10px; /* Add space between fields */
    padding: 10px;
    border: 1px solid #ccc;
    margin-top: 10px;
    border-radius: 5px;
}
#hardFields.hidden, #softFields.hidden {
    display: none !important;
}

</style>
<script>
function generatePromo() {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    let code = "";
    for (let i = 0; i < 8; i++) {
        code += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById("promoInput").value = code;
}

document.addEventListener("DOMContentLoaded", function() {
    const addonTypeSelect = document.getElementById('addon_type');
    const hardFields = document.getElementById('hardFields'); // Corrected ID reference
    const softFields = document.getElementById('softFields'); // Corrected ID reference

    function toggleFields() {
        const type = addonTypeSelect.value;
        hardFields.style.display = (type === 'hard') ? 'block' : 'none'; // Use 'block' or other appropriate display value
        softFields.style.display = (type === 'soft') ? 'block' : 'none'; // Use 'block' or other appropriate display value
    }

    if (addonTypeSelect) {
        // Initialize display based on current selection (if any)
        toggleFields();

        // Add change event listener
        addonTypeSelect.addEventListener('change', toggleFields);
    }
});
</script>



</head>
<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
        <?php include 'menu.php'; ?>
    </div>

    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button"><button class="btn toggle_btn" type="button"></button></div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?= strtoupper(substr($user['full_name'], 0, 2)) ?></span>
                    <div class="user_name"><h4><?= htmlspecialchars($user['full_name']) ?></h4></div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
            <!-- Add-on Form -->
            <div class="mb-4 p-3 border rounded">
                <h4>Add Add-on</h4>
                <?php
                // Display success/error messages specific to the Add-on form submission
                if (!empty($successAddon)) echo "<div class='alert alert-success'>$successAddon</div>";
                if (!empty($errorAddon)) echo "<div class='alert alert-danger'>$errorAddon</div>";
                ?>
                <form method="post" enctype="multipart/form-data" id="addonForm">
                    <div class="mb-2">
                        <label for="addon_type" class="form-label">Select Add-on Type</label>
                        <select name="addon_type" id="addon_type" class="form-select" required>
                            <option value="">-- Select Type --</option>
                            <option value="hard" <?= (isset($_POST['addon_type']) && $_POST['addon_type'] == 'hard') ? 'selected' : '' ?>>Hard Copy</option>
                            <option value="soft" <?= (isset($_POST['addon_type']) && $_POST['addon_type'] == 'soft') ? 'selected' : '' ?>>Soft Copy</option>
                        </select>
                    </div>

                    <!-- Hard Copy Fields -->
                    <div id="hardFields" style="display: none;">
                        <label class="fw-bold">Hard Copy Details</label>
                        <input type="text" name="addon_name" class="form-control" placeholder="Hard Copy Name" value="<?= htmlspecialchars($_POST['addon_name'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_hard_booklet_card_price" class="form-control" placeholder="Booklet + Card Price" value="<?= htmlspecialchars($_POST['addon_hard_booklet_card_price'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_hard_booklet_only_price" class="form-control" placeholder="Booklet Only Price" value="<?= htmlspecialchars($_POST['addon_hard_booklet_only_price'] ?? '') ?>">
                    </div>

                    <!-- Soft Copy Fields -->
                    <div id="softFields" style="display: none;">
                        <label class="fw-bold">Soft Copy Details</label>
                        <input type="text" name="addon_soft_product_name" class="form-control" placeholder="Soft Copy Name" value="<?= htmlspecialchars($_POST['addon_soft_product_name'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_soft_booklet_card_price" class="form-control" placeholder="Soft Booklet + Card Price" value="<?= htmlspecialchars($_POST['addon_soft_booklet_card_price'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_soft_booklet_only_price" class="form-control" placeholder="Soft Booklet Only Price" value="<?= htmlspecialchars($_POST['addon_soft_booklet_only_price'] ?? '') ?>">
                    </div>

                    <div class="mb-2">
                         <label for="addon_image" class="form-label">Image (Max 300KB, jpg, png, gif, svg)</label>
                        <input type="file" name="addon_image" id="addon_image" class="form-control" accept="image/*">
                    </div>

                    <button type="submit" name="add_addon" class="btn btn-primary mt-2">Add Add-on</button>
                </form>


                <!-- Add-ons Table -->
                <h5 class="mt-4">Current Add-ons</h5>

                <h6 class="mt-3">Hard Copy Add-ons</h6>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr><th>Name</th><th>Booklet+Card Price</th><th>Booklet Only Price</th><th>Image</th><th>Action</th></tr>
                    </thead>
                    <tbody>
                    <?php
                    // Fetch only rows that are clearly hard copies
                    $hard_addons = $conn->query("SELECT * FROM addon_products WHERE name IS NOT NULL AND name != '' ORDER BY id DESC");
                    if ($hard_addons->num_rows > 0):
                        while($row = $hard_addons->fetch_assoc()):
                    ?>
                        <tr>
                            <td><?= htmlspecialchars($row['name']) ?></td>
                            <td><?= $row['addon_hard_booklet_card_price'] > 0 ? '$'.number_format($row['addon_hard_booklet_card_price'],2) : '-' ?></td>
                            <td><?= $row['addon_hard_booklet_only_price'] > 0 ? '$'.number_format($row['addon_hard_booklet_only_price'],2) : '-' ?></td>
                            <td>
                                <?php $img = getAddonImage($row, 'hard'); ?>
                                <?php if($img): ?>
                                    <img src="uploads/<?= htmlspecialchars($img) ?>" alt="Hard Addon Image" style="height:50px">
                                <?php else: ?>No Image<?php endif; ?>
                            </td>
                            <td>
                                <a href="?delete_addon=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this Hard Copy add-on?')">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile;
                     else: ?>
                         <tr><td colspan="5" class="text-center">No Hard Copy add-ons found.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>

                <h6 class="mt-3">Soft Copy Add-ons</h6>
                <table class="table table-bordered table-striped">
                     <thead>
                        <tr><th>Name</th><th>Booklet+Card Price</th><th>Booklet Only Price</th><th>Image</th><th>Action</th></tr>
                    </thead>
                    <tbody>
                    <?php
                    // Fetch only rows that are clearly soft copies
                    $soft_addons = $conn->query("SELECT * FROM addon_products WHERE addon_soft_product_name IS NOT NULL AND addon_soft_product_name != '' ORDER BY id DESC");
                     if ($soft_addons->num_rows > 0):
                         while($row = $soft_addons->fetch_assoc()):
                    ?>
                        <tr>
                            <td><?= htmlspecialchars($row['addon_soft_product_name']) ?></td>
                             <td><?= $row['addon_soft_booklet_card_price'] > 0 ? '$'.number_format($row['addon_soft_booklet_card_price'],2) : '-' ?></td>
                            <td><?= $row['addon_soft_booklet_only_price'] > 0 ? '$'.number_format($row['addon_soft_booklet_only_price'],2) : '-' ?></td>
                            <td>
                                <?php $img = getAddonImage($row, 'soft'); ?>
                                <?php if($img): ?>
                                    <img src="uploads/<?= htmlspecialchars($img) ?>" alt="Soft Addon Image" style="height:50px">
                                <?php else: ?>No Image<?php endif; ?>
                            </td>
                            <td>
                                <a href="?delete_addon=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this Soft Copy add-on?')">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile;
                     else: ?>
                         <tr><td colspan="5" class="text-center">No Soft Copy add-ons found.</td></tr>
                     <?php endif; ?>
                    </tbody>
                </table>

            </div>

            <!-- Validity Section -->
            <div class="mb-4 p-3 border rounded">
           <div class="mb-4 p-3 border rounded">
                <h4>Add Validity Option</h4>
                <?php if(isset($successValidity)) echo "<div class='alert alert-success'>$successValidity</div>"; ?>
                <?php if(isset($errorValidity)) echo "<div class='alert alert-danger'>$errorValidity</div>"; ?>

                <!-- Updated Form for Validity -->
                <form method="post" class="row g-2 mb-3 align-items-end">
                    <div class="col-md-3">
                        <label for="validity_name_input" class="form-label">Validity Name</label>
                        <input type="text" id="validity_name_input" name="validity" class="form-control" placeholder="e.g., 1 Month, 3 Months" required value="<?= htmlspecialchars($_POST['validity'] ?? '') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_only_hard_input" class="form-label">Booklet Only (Hard)</label>
                        <!-- Use type="number" and step="0.01" for price inputs -->
                        <input type="number" step="0.01" id="booklet_only_hard_input" name="booklet_only_hard" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_only_hard'] ?? '0.00') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_card_hard_input" class="form-label">Booklet Card (Hard)</label>
                        <input type="number" step="0.01" id="booklet_card_hard_input" name="booklet_card_hard" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_card_hard'] ?? '0.00') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_card_soft_input" class="form-label">Booklet Card (Soft)</label>
                        <input type="number" step="0.01" id="booklet_card_soft_input" name="booklet_card_soft" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_card_soft'] ?? '0.00') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_only_soft_input" class="form-label">Booklet Only (Soft)</label>
                        <input type="number" step="0.01" id="booklet_only_soft_input" name="booklet_only_soft" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_only_soft'] ?? '0.00') ?>">
                    </div>
                    <div class="col-12"> <!-- Button on its own line for better layout -->
                        <button type="submit" name="add_validity" class="btn btn-primary">Add Validity Option</button>
                    </div>
                </form>

                <table class="table table-bordered">
                    <thead>
                        <tr> 
                            <th>Validity Name</th> 
                            <th>Booklet Only (Hard)</th>
                            <th>Booklet Card (Hard)</th>
                            <th>Booklet Card (Soft)</th>
                            <th>Booklet Only (Soft)</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    // $validities is already fetched with SELECT * FROM addon_validity
                    if ($validities->num_rows > 0) { // Check if there are any rows to display
                        while($row = $validities->fetch_assoc()):
                    ?>
                        <tr> 
                            <td><?= htmlspecialchars($row['validity']) ?></td> 
                            <!-- Format prices, display '-' if 0 or not set -->
                            <td><?= $row['booklet_only_hard'] > 0 ? '$'.number_format($row['booklet_only_hard'], 2) : '-' ?></td>
                            <td><?= $row['booklet_card_hard'] > 0 ? '$'.number_format($row['booklet_card_hard'], 2) : '-' ?></td>
                            <td><?= $row['booklet_card_soft'] > 0 ? '$'.number_format($row['booklet_card_soft'], 2) : '-' ?></td>
                            <td><?= $row['booklet_only_soft'] > 0 ? '$'.number_format($row['booklet_only_soft'], 2) : '-' ?></td>
                            <td><a href="?delete_validity=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this validity option?')">Delete</a></td>
                        </tr>
                    <?php
                        endwhile;
                    } else { // If no rows were fetched
                    ?>
                        <tr>
                            <td colspan="8" class="text-center">No validity options found.</td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>

            <!-- Promo Section -->
            <div class="mb-4 p-3 border rounded">
                <h4>Add Promo Code</h4>
                <?php if(isset($successPromo)) echo "<div class='alert alert-success'>$successPromo</div>"; ?>
                <?php if(isset($errorPromo)) echo "<div class='alert alert-danger'>$errorPromo</div>"; ?>
                <form method="post" class="row g-2 mb-2 align-items-end">
                    <div class="col-md-3">
                        <label for="promoInput" class="form-label">Promo Code</label>
                        <div class="d-flex">
                            <input type="text" id="promoInput" name="promo" class="form-control" placeholder="Promo Code" required value="<?= htmlspecialchars($_POST['promo'] ?? '') ?>">
                            <button type="button" class="btn btn-secondary btn-sm" onclick="generatePromo()">Generate</button>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label for="discount_type" class="form-label">Discount Type</label>
                        <select name="discount_type" id="discount_type" class="form-select">
                            <option value="percent" <?= (isset($_POST['discount_type']) && $_POST['discount_type'] == 'percent') ? 'selected' : '' ?>>Percent (%)</option>
                            <option value="fixed" <?= (isset($_POST['discount_type']) && $_POST['discount_type'] == 'fixed') ? 'selected' : '' ?>>Fixed Amount</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="discount_value" class="form-label">Discount Value</label>
                        <input type="number" step="0.01" id="discount_value" name="discount_value" class="form-control" placeholder="Value" required value="<?= htmlspecialchars($_POST['discount_value'] ?? '') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="expiry_date" class="form-label">Expiry Date</label>
                        <input type="date" id="expiry_date" name="expiry_date" class="form-control" value="<?= htmlspecialchars($_POST['expiry_date'] ?? '') ?>">
                    </div>
                     <div class="col-md-12 mt-2">
                         <button type="submit" name="add_promo" class="btn btn-primary">Add Promo</button>
                    </div>
                </form>

                <table class="table table-bordered mt-3">
                    <thead>
                        <tr>
                            <th>ID</th><th>Promo Code</th><th>Discount Type</th><th>Discount Value</th><th>Expiry Date</th><th>Usage Limit</th><th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php while($row=$promos->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['promo']) ?></td>
                            <td><?= ucfirst($row['discount_type']) ?></td>
                            <td><?= $row['discount_type']=='percent'? number_format($row['discount_value'], 2).'%':'$'.number_format($row['discount_value'],2) ?></td>
                            <td><?= $row['expiry_date']?htmlspecialchars($row['expiry_date']):'-' ?></td>
                             <td><?= $row['usage_limit'] ?? '-' ?></td>
                            <td><a href="?delete_promo=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete Promo?')">Delete</a></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>
</body>
</html>