
<?php
include 'session.php';

?>
<!DOCTYPE html>
<html>

<head>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Step 1 - Applicant's Details</title>
  <?php include('link.php'); ?>
  
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
</head>

<body>
  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

  <div class="step-progress">
    <div class="step"><span class="number">01</span><span class="label">Applicant's Details</span></div>
    <div class="step active"><span class="number">02</span><span class="label">Choose Plan</span></div>
    <div class="step"><span class="number">03</span><span class="label">Review</span></div>
    <div class="step"><span class="number">04</span><span class="label">Payment</span></div>
  </div>
  </section>


  <div class="licenceform">
    <div class="container">


      <div class="main-form-container">

        <div class="form-container">
          <h2>Applicant’s Details</h2>
          <form method="post" action="save_step1.php">
            <div class="licenceform-row">
              <div class="formfield">
                <label>First Name *</label>
                <input type="text" name="first_name" required>
              </div>
              <div class="formfield">
                <label>Last Name *</label>
                <input type="text" name="last_name" required>
              </div>
              <div class="formfield">
                <label>Email *</label>
                <input type="email" name="email" required>
              </div>
              <div class="formfield">
                <label>WhatsApp Number *</label>
                <input type="text" name="whatsapp" required>
              </div>
              <div class="formfield">
                <label>Date of Birth *</label>
                <div style="display: flex; gap: 10px;">
                  <input type="text" name="dob_month" placeholder="Month" required>
                  <input type="text" name="dob_day" placeholder="Day" required>
                  <input type="text" name="dob_year" placeholder="Year" required>
                </div>
              </div>
              <div class="formfield" style="display:none;">
                <label>Place of Birth *</label>
                <select id="birth" name="birth_place">
                  <option value="" disabled selected>Select Country</option>
                </select>
                <input type="hidden" id="birth_hidden" name="birth_code">

              </div>
         
                <div class="formfield full-field">
                  <label>Street Address *</label>
                  <input type="text" name="street" required>
                </div>
                
                
                <div class="formfield full-field">
                  <label>State/Region/Province *</label><br>
                   
                    <input type="text" id="state" name="state"  >
                </div>
                
                <div class="formfield full-field">
                  <label>ZIP *</label>
                  <input type="text" id="zip" name="zip" required>
                </div>
              
               
              <div class="formfield full-field" style="display:none">
                  <label>Permanent Place of Residence *</label>
                 <select id="permanent" name="permanent_place" >
                  <option value="" disabled selected>Select Country</option>
                </select>
                <input type="hidden" id="permanent_code" name="permanent_code">
            </div>
            
                <div class="formfield full-field">
                  <label>Permanent Place of Residence *</label>
                  <select id="country" name="country_name" required><option value="" disabled selected>Select Country</option></select>
                    <input type="hidden" id="country_hidden" name="country_code" placeholder="Select Country">
                    
                </div>
                
            
              
                <div class="formfield full-field">
                  <label>City *</label>
                  <input type="text" id="city" name="city" readonly required>
                </div>

              <div class="formfield" style="display:none">
                <label>Gender *</label>
                <div class="gender-group">
                  <label class="gender-box active" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Male" checked>
                    <img style="margin-bottom:6px;" src="assets/images/male.svg"><br> Male
                  </label>
                  <label class="gender-box" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Female">
                    <img style="margin-bottom:6px;" src="assets/images/female.svg"><br> Female
                  </label>
                </div>
              </div>
            </div>

            <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
          </form>
        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>

      </div>


    </div>
  </div>





  <?php include('footer.php'); ?>



  <script>
    function selectGender(el) {
      document.querySelectorAll('.gender-box').forEach(box => box.classList.remove('active'));
      el.classList.add('active');
      el.querySelector('input').checked = true;
    }
  </script>

<script>
document.addEventListener("DOMContentLoaded", function () {
  const countrySelect = document.getElementById("country");
  const birthSelect = document.getElementById("birth");
  const permanentSelect = document.getElementById("permanent");
  const countryHidden = document.getElementById("country_hidden");
  const birthHidden = document.getElementById("birth_hidden");
  const permanentHidden = document.getElementById("permanent_code");
  const zipInput = document.getElementById("zip");
  const cityInput = document.getElementById("city"); 
  const stateSelect = document.getElementById("state");

  // Load countries dynamically
  fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
      countries.forEach(c => {
        const option1 = document.createElement("option");
        option1.value = c.code; // 2-letter ISO
        option1.textContent = c.name;
        countrySelect.appendChild(option1);

        const option2 = document.createElement("option");
        option2.value = c.code;
        option2.textContent = c.name;
        birthSelect.appendChild(option2);

        const option3 = document.createElement("option");
        option3.value = c.code;
        option3.textContent = c.name;
        permanentSelect.appendChild(option3);
      });

      // Optional: if a country is pre-selected
      if (countrySelect.value) countryHidden.value = countrySelect.value;
      if (birthSelect.value) birthHidden.value = birthSelect.value;
      if (permanentSelect.value) permanentHidden.value = permanentSelect.value;
    })
    .catch(err => console.error("Error loading countries:", err));

  // Update hidden country codes on selection
  countrySelect.addEventListener("change", () => {
    countryHidden.value = countrySelect.value;
  });
  birthSelect.addEventListener("change", () => {
    birthHidden.value = birthSelect.value;
  });
  permanentSelect.addEventListener("change", () => {
    permanentHidden.value = permanentSelect.value;
  });

  // Auto-fill city and state on ZIP blur
  zipInput.addEventListener("blur", function () {
    const zip = zipInput.value.trim();
    const country = countrySelect.value;
    if (!zip || !country) return;

    $.getJSON(`https://bdma.co.in/dhl/get_location.php?zip=${zip}&country=${country}`, function (res) {
      if (res.city) {
        cityInput.value = res.city;
        stateSelect.value = res.state || '';
      } else {
        cityInput.value = '';
        stateSelect.value = '';
        if(res.error) alert(res.error);
      }
    }).fail(function () {
      cityInput.value = '';
      stateSelect.value = '';
      alert("Failed to fetch location. Please check the ZIP or country.");
    });
  });
});
</script>





  <?php include('footerscript.php'); ?>



</body>

</html>