<?php
include 'session.php';

if (!isset($_SESSION['step2'])) {
    header("Location: step2.php");
    exit;
}
 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    // Save file names in session
    $_SESSION['step3'] = [
        'passport_photo' => $_FILES['passport_photo']['name'],
        'license_front' => $_FILES['license_front']['name'],
        'license_back' => $_FILES['license_back']['name']
    ];

    // Move uploaded files to 'uploads/' folder
    $uploadDir = 'uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true);
    }

    move_uploaded_file($_FILES['passport_photo']['tmp_name'], $uploadDir . basename($_FILES['passport_photo']['name']));
    move_uploaded_file($_FILES['license_front']['tmp_name'], $uploadDir . basename($_FILES['license_front']['name']));
    move_uploaded_file($_FILES['license_back']['tmp_name'], $uploadDir . basename($_FILES['license_back']['name']));

     // Check selected plan from step2 and redirect accordingly
    $copyType = $_SESSION['copy_type'] ?? '';

    if ($copyType === 'soft') {
        header('Location: step5.php'); // Skip shipping
    } else {
        header('Location: step4.php'); // Go to shipping
    }

    exit;
}
 
?>

<!DOCTYPE html>
<html>

<head>
    <title>Step 3 - Upload Document</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <?php include('link.php'); ?>
</head>

<body>

    <?php include('header.php'); ?>

    <section class="step-section steplicence">
        <div class="step-header">
            <h1>Apply for International Driving License</h1>
            <p>Most accepted at the global level & trusted by travellers all around the world</p>
        </div>

        <div class="step-progress">
            <div class="step ">
                <span class="number">01</span>
                <span class="label">Applicant’s Details</span>
            </div>
            <div class="step ">
                <span class="number">02</span>
                <span class="label">Choose Plan</span>
            </div>
            <div class="step active">
                <span class="number">03</span>
                <span class="label">Add Document</span>
            </div>
            <div class="step">
                <span class="number">04</span>
                <span class="label">Shipping</span>
            </div>
            <div class="step">
                <span class="number">04</span>
                <span class="label">Review</span>
            </div>
            <div class="step">
                <span class="number">05</span>
                <span class="label">Payment</span>
            </div>
        </div>
    </section>

    <div class="licenceform">
        <div class="container">
            <div class="main-form-container">
                <div class="form-container">
                    <h2>Upload Document <span class="hover_span"><svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="none"  stroke="currentColor"  stroke-width="2"  stroke-linecap="round"  stroke-linejoin="round"  class="icon icon-tabler icons-tabler-outline icon-tabler-exclamation-circle"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0" /><path d="M12 9v4" /><path d="M12 16v.01" /></svg>
                        <p class="hover_text">Please upload an image<br> (maximum size: 10MB)</p>
                    </span></h2>
                    <p>Please upload the document. These are required for verification of your application.</p>
                    <form method="post" action="" enctype="multipart/form-data">

                        <!-- Passport Photo -->
                        <label><strong>01. Passport Size Photo *</strong></label><br>
                        <div class="dl-passport">
                            <img src="assets/images/upload-image.svg" alt="Soft">
                            <input type="file" name="passport_photo" required>
                        </div>
                        <br>

                        <!-- Driving License -->
                        <label><strong>02. Driving License *</strong></label><br>
                        <div class="dl-photo-wrap">
                            <div class="dl-photo">
                                <p>Front side</p>
                                <img src="assets/images/front.svg" alt="Soft">
                                <input type="file" name="license_front" required>
                            </div>
                            <div class="dl-photo">
                                <p>Back side</p>
                                <img src="assets/images/back.svg" alt="Soft">
                                <input type="file" name="license_back" required>
                            </div>
                        </div>
                        <br>

                        <!-- Buttons -->
                        <div class="back-continue-button-wrap">
                            <a href="step2.php"><button type="button" class="first-btn-cicle">Back</button></a>
                            <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
                        </div>
                    </form>
                </div>

                <div class="global-container">
                    <?php include('stats-card.php'); ?>
                </div>
            </div>
        </div>
    </div>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const hamburger = document.querySelector('.hamburger');
            const navLinks = document.querySelector('.nav-links');

            if (hamburger && navLinks) {
                hamburger.addEventListener('click', function() {
                    navLinks.classList.toggle('active');
                });
            }
        });
    </script>

    <?php include('footer.php'); ?>
    <?php include('footerscript.php'); ?>
</body>

</html>