<?php
// ajax_remove_image.php
include '../db.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['image'], $_POST['id'])) {
    $allowed_fields = ['passport_photo', 'license_front', 'license_back', 'license_class'];
    $image_field = $_POST['image'];
    $id = (int)$_POST['id'];

    if (!in_array($image_field, $allowed_fields)) {
        echo 'invalid';
        exit;
    }

    // Fetch filename
    $stmt = $conn->prepare("SELECT $image_field FROM applications WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    $result = $stmt->get_result();
    $application = $result->fetch_assoc();

    if (!$application || empty($application[$image_field])) {
        echo 'not_found';
        exit;
    }

    $file_path = '../uploads/' . $application[$image_field];

    // Delete file from server
    if (file_exists($file_path)) {
        unlink($file_path);
    }

    // Update DB
    $stmt = $conn->prepare("UPDATE applications SET $image_field = '' WHERE id = ?");
    $stmt->bind_param("i", $id);
    if ($stmt->execute()) {
        echo 'success';
    } else {
        echo 'db_error';
    }
} else {
    echo 'invalid_request';
}
