<?php
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$host = 'localhost';
$db   = 'bdmaco_dhl';
$user = 'bdmaco_dhlet';
$pass = 'Dhlet@123';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$db;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    // --- 1. Fetch Validity Data ---
    $validityStmt = $pdo->query("SELECT id, validity, booklet_only_hard, booklet_card_hard, booklet_card_soft, booklet_only_soft FROM addon_validity");
    $validityRows = $validityStmt->fetchAll(PDO::FETCH_ASSOC);

    $validityData = [
        'Booklet' => [],
        'Booklet + Card' => []
    ];
    
    foreach ($validityRows as $row) {
        $id = (int)$row['id'];
        $validityName = $row['validity'];
    
        $validityData['Booklet'][$id] = [
            'validity_name' => $validityName,
            'addons' => [
                'soft' => ['id' => $id, 'name' => 'Soft Copy', 'price' => (float)$row['booklet_only_soft']],
                'hard' => ['id' => $id, 'name' => 'Hard Copy', 'price' => (float)$row['booklet_only_hard']]
            ]
        ];

        $validityData['Booklet + Card'][$id] = [
            'validity_name' => $validityName,
            'addons' => [
                'soft' => ['id' => $id, 'name' => 'Soft Copy', 'price' => (float)$row['booklet_card_soft']],
                'hard' => ['id' => $id, 'name' => 'Hard Copy', 'price' => (float)$row['booklet_card_hard']]
            ]
        ];
    }

    // --- 2. Fetch Additional Add-on Products ---
    $productsStmt = $pdo->query("SELECT * FROM addon_products");
    $additionalAddons = $productsStmt->fetchAll(PDO::FETCH_ASSOC);

    // --- 3. Combine into a single response object ---
    $response = [
        'validity_data' => $validityData,
        'additional_addons' => $additionalAddons
    ];
    
    echo json_encode($response, JSON_PRETTY_PRINT);

} catch (PDOException $e) {
    http_response_code(500);
    error_log("Database Error: " . $e->getMessage());
    echo json_encode(['error' => 'A database error occurred on the server.']);
}
?>