<?php
session_start();

if (!isset($_SESSION['step1'], $_SESSION['step2'], $_SESSION['step3'])) {
    die("Session data not found. Please start the application process again.");
}

$step1 = $_SESSION['step1'] ?? [];
$step2 = $_SESSION['step2'] ?? [];
$step4 = $_SESSION['step4'] ?? [];
$order_id = $_SESSION['order_id'] ?? 'N/A';

$plan = $step2['plan'] ?? 'Soft Copy';

$filename = "review_details_" . preg_replace('/[^a-zA-Z0-9_]/', '', $order_id) . ".csv";

header('Content-Type: text/csv');
header('Content-Disposition: attachment; filename="' . $filename . '"');

$output = fopen('php://output', 'w');

fputcsv($output, ['Field', 'Value']);

fputcsv($output, ['Applicant\'s Details', '']);
fputcsv($output, ['Full Name', $step1['full_name'] ?? '']);
fputcsv($output, ['Date of Birth', $step1['dob'] ?? '']);
fputcsv($output, ['Gender', $step1['gender'] ?? '']);
fputcsv($output, ['Email', $step1['email'] ?? '']);
fputcsv($output, ['Phone', $step1['phone'] ?? '']);
fputcsv($output, ['Nationality', $step1['nationality'] ?? '']);
fputcsv($output, ['Country of License', $step2['license_country'] ?? '']);
fputcsv($output, ['Permanent Place of Residence', $step1['birth_place'] ?? '']);
fputcsv($output, ['Street', $step1['street'] ?? '']);
fputcsv($output, ['State', $step1['state'] ?? '']);
fputcsv($output, ['City', $step1['city'] ?? '']);

fputcsv($output, []);

fputcsv($output, ['Choose Plan', '']);
fputcsv($output, ['Plan', $plan]);
fputcsv($output, ['Type', $step2['type'] ?? '']);
fputcsv($output, ['Intended Country to Drive', $step2['drive_country'] ?? '']);
$license_class_str = !empty($step2['license_class']) ? implode(', ', $step2['license_class']) : '';
fputcsv($output, ['License Classes', $license_class_str]);
fputcsv($output, ['Product', $step2['productbooklet'] ?? '']);
fputcsv($output, ['Validity', $step2['validity'] ?? '']);
fputcsv($output, ['Promo Code', $step2['promo'] ?? 'N/A']);

if ($plan === 'Hard Copy') {
    fputcsv($output, []);
    fputcsv($output, ['Shipping Address', '']);
    $recipient_name = ($step4['first_name'] ?? '') . ' ' . ($step4['last_name'] ?? '');
    fputcsv($output, ['Recipient Name', $recipient_name]);
    fputcsv($output, ['House/Flat/Block No.', $step4['ship_house'] ?? '']);
    fputcsv($output, ['Street/Area', $step4['ship_street'] ?? '']);
    fputcsv($output, ['City', $step4['city'] ?? '']);
    fputcsv($output, ['State/Region/Province', $step4['state'] ?? '']);
    fputcsv($output, ['ZIP/Postal Code', $step4['zip'] ?? '']);
    fputcsv($output, ['Country', $step4['country_code'] ?? '']);
}

fputcsv($output, []);

fputcsv($output, ['Order Summary', '']);
$productPrice = floatval($_SESSION['step2']['product_price'] ?? $_SESSION['step2']['total'] ?? 0);
fputcsv($output, ['Product Price', '£' . number_format($productPrice, 2)]);

$shippingPrice = 0;
if ($plan === 'Hard Copy') {
    $shippingPrice = floatval($_SESSION['shipping_rate'] ?? 0);
    fputcsv($output, ['Shipping Price', '£' . number_format($shippingPrice, 2)]);
}

$total = ($plan === 'Hard Copy') ? floatval($_SESSION['total_price'] ?? ($productPrice + $shippingPrice)) : $productPrice;
fputcsv($output, ['Total Amount', '£' . number_format($total, 2)]);
fputcsv($output, ['Order ID', $order_id]);

fclose($output);
exit;