<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h3>PHP Debug Check</h3>";

$license_api = 'https://newsprtoday.site/leads/check_domain.php';
$domain = strtolower(preg_replace('#^www\.#', '', $_SERVER['HTTP_HOST'] ?? ''));
echo "Domain: $domain<br>";

$response = @file_get_contents($license_api . '?domain=' . urlencode($domain));
if ($response === false) {
    echo "API call failed.<br>";
} else {
    echo "API Response: " . htmlspecialchars($response) . "<br>";
}

$data = json_decode($response, true);
if (json_last_error() !== JSON_ERROR_NONE) {
    echo "JSON Decode Error: " . json_last_error_msg() . "<br>";
} else {
    var_dump($data);
}
?>
