<?php
// ajax_upgrade.php

session_start();
include 'db.php';

header('Content-Type: application/json');

if (!isset($_SESSION['order_id'])) {
    echo json_encode(['success' => false, 'message' => 'Session not found.']);
    exit;
}

// 1. Fetch the upgrade price from the database
$upgrade_price = 0;
$result = $conn->query("SELECT amount FROM booklate_upgrade WHERE id = 1");
if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    $upgrade_price = floatval($row['amount']);
} else {
    echo json_encode(['success' => false, 'message' => 'Upgrade price not configured.']);
    exit;
}

// --- START OF THE FIX ---

// 2. Get the ORIGINAL base price from session, checking BOTH possible keys.
// This is the key change to fix the "£0.00" issue.
$productPrice = floatval($_SESSION['step2']['product_price'] ?? $_SESSION['step2']['total'] ?? 0);
$shippingPrice = floatval($_SESSION['shipping_rate'] ?? 0);

// If productPrice is still 0, something is wrong. We stop here.
if ($productPrice <= 0) {
    echo json_encode(['success' => false, 'message' => 'Could not find original product price in session.']);
    exit;
}

// 3. Calculate the new total from the base components.
$newTotal = $productPrice + $shippingPrice + $upgrade_price;

// --- END OF THE FIX ---

// 4. Update the session variables with the upgraded information
$_SESSION['step2']['productbooklet'] = 'Booklet + Card';
$_SESSION['upgrade_amount'] = $upgrade_price;
$_SESSION['total_price'] = $newTotal;

// 5. Send the new data back to the browser
$response = [
    'success' => true,
    'newProductName' => 'Booklet + Card',
    'upgradePrice' => $upgrade_price,
    'newTotalPrice' => $newTotal
];

echo json_encode($response);
exit;
?>