<?php
include '../db.php';
$conn->set_charset("utf8mb4");
session_start();

if(!isset($_SESSION['user_id'])){
    header('Location: login.php');
    exit;
}

// Fetch the most recent form_controll entry. This is used to get existing file names
// before processing new uploads, so we can delete old files if a new one is provided.
$formControll = $conn->query("SELECT * FROM form_controll ORDER BY id DESC LIMIT 1")->fetch_assoc();


$user = ['full_name' => 'User']; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $soft_copy_price = $conn->real_escape_string($_POST['soft_copy_price']);
    $hard_copy_price = $conn->real_escape_string($_POST['hard_copy_price']);
    $urgent_type_price = $conn->real_escape_string($_POST['urgent_type_price']);
    $weekend_type_price = $conn->real_escape_string($_POST['weekend_type_price']);
    $normal_type_price = $conn->real_escape_string($_POST['normal_type_price']);
    
    // --- Driving License Classes Logic (unchanged) ---
    $driving_classes = [];
    $existing_classes_data = [];
    if (!empty($formControll['driving_license_classes'])) {
        foreach (json_decode($formControll['driving_license_classes'], true) as $old) {
            $existing_classes_data[$old['id']] = $old;
        }
    }

    $updated_classes = [];
    foreach ($_POST['class_id'] as $i => $classId) {
        $label = trim($_POST['class_label'][$i] ?? '');
        $price = trim($_POST['class_price'][$i] ?? '');

        if ($label === '') continue;

        $imageName = $existing_classes_data[$classId]['image'] ?? ''; 
        if (!empty($_FILES['class_image']['name'][$i])) {
            if (!empty($imageName) && file_exists("uploads/$imageName")) {
                unlink("uploads/$imageName"); 
            }
            $ext = pathinfo($_FILES['class_image']['name'][$i], PATHINFO_EXTENSION);
            $imageName = uniqid('class_') . '.' . $ext;
            move_uploaded_file($_FILES['class_image']['tmp_name'][$i], "uploads/$imageName");
        }
        $updated_classes[] = [
            'id'    => $classId,
            'label' => $label,
            'price' => $price,
            'image' => $imageName
        ];
    }
    $driving_classes_json = json_encode($updated_classes);
    // --- End Driving License Classes Logic ---

    $uploadDir = 'uploads/';

    // Get current file names from the database for comparison and deletion
    $current_soft_copy_file = $formControll['soft_copy_file'] ?? '';
    $current_hard_copy_file = $formControll['hard_copy_file'] ?? '';
    
    // Using only the two selected columns for the Booklet options
    $current_booklet_front_image = $formControll['booklet_front_image'] ?? '';
    $current_booklet_card_booklet_front_image = $formControll['booklet_card_booklet_front_image'] ?? '';

    // Initialize filenames with existing ones, they will be overwritten if new files are uploaded
    $softCopyFileName = $current_soft_copy_file;
    $hardCopyFileName = $current_hard_copy_file;
    $bookletFrontImageName = $current_booklet_front_image;
    $bookletCardBookletFrontImageName = $current_booklet_card_booklet_front_image;


    // Helper function for file uploads
    function handleFileUpload($fileInputName, $currentFileName, $uploadDir, &$targetFileName) {
        global $conn; // Access the database connection for real_escape_string
        if (isset($_FILES[$fileInputName]) && $_FILES[$fileInputName]['error'] === UPLOAD_ERR_OK) {
            // Delete old file if it exists
            if (!empty($currentFileName) && file_exists($uploadDir . $currentFileName)) {
                unlink($uploadDir . $currentFileName);
            }
            // Upload new file
            $ext = pathinfo($_FILES[$fileInputName]['name'], PATHINFO_EXTENSION);
            $targetFileName = uniqid($fileInputName . '_') . '.' . $ext;
            move_uploaded_file($_FILES[$fileInputName]['tmp_name'], $uploadDir . $targetFileName);
        }
        // Return file name for DB, or NULL if no file
        return !empty($targetFileName) ? "'" . $conn->real_escape_string($targetFileName) . "'" : "NULL";
    }

    // Process Soft Copy File
    $softCopyFileNameForDB = handleFileUpload('soft_copy_file', $current_soft_copy_file, $uploadDir, $softCopyFileName);

    // Process Hard Copy File
    $hardCopyFileNameForDB = handleFileUpload('hard_copy_file', $current_hard_copy_file, $uploadDir, $hardCopyFileName);

    // Process Booklet Front Image (for "Booklet" section)
    $bookletFrontImageNameForDB = handleFileUpload('booklet_front_image', $current_booklet_front_image, $uploadDir, $bookletFrontImageName);

    // Process Booklet + Card: Booklet Front Image (for "Booklet + Card" section)
    $bookletCardBookletFrontImageNameForDB = handleFileUpload('booklet_card_booklet_front_image', $current_booklet_card_booklet_front_image, $uploadDir, $bookletCardBookletFrontImageName);

    // The other two columns (booklet_back_image, booklet_card_card_front_image) are NOT handled here
    // If you want to explicitly set them to NULL if no new value comes from the form,
    // you would need to add logic here, but for now, they will retain their existing values if not touched.
    $bookletBackImageNameForDB = !empty($formControll['booklet_back_image']) ? "'" . $conn->real_escape_string($formControll['booklet_back_image']) . "'" : "NULL";
    $bookletCardCardFrontImageNameForDB = !empty($formControll['booklet_card_card_front_image']) ? "'" . $conn->real_escape_string($formControll['booklet_card_card_front_image']) . "'" : "NULL";


    // Check if a record already exists to UPDATE or INSERT
    $check_sql = "SELECT id FROM form_controll LIMIT 1";
    $check_result = $conn->query($check_sql);

    if ($check_result && $check_result->num_rows > 0) {
        $row_check = $check_result->fetch_assoc(); 
        $id = $row_check['id'];

        $update_fields = "
            soft_copy_price = '$soft_copy_price',
            hard_copy_price = '$hard_copy_price',
            urgent_type_price = '$urgent_type_price',
            weekend_type_price = '$weekend_type_price',
            normal_type_price = '$normal_type_price',
            driving_license_classes = '$driving_classes_json',
            soft_copy_file = $softCopyFileNameForDB,
            hard_copy_file = $hardCopyFileNameForDB,
            booklet_front_image = $bookletFrontImageNameForDB,                 
            booklet_back_image = $bookletBackImageNameForDB,                   -- Still included, but will retain existing value if not explicitly changed
            booklet_card_booklet_front_image = $bookletCardBookletFrontImageNameForDB, 
            booklet_card_card_front_image = $bookletCardCardFrontImageNameForDB   -- Still included, but will retain existing value if not explicitly changed
        ";

        $sql = "UPDATE form_controll SET $update_fields WHERE id = $id";
    } else {
        // For INSERT, we'll only provide values for the fields we're actively managing.
        // The other booklet-related fields will be NULL by default.
        $columns = "soft_copy_price, hard_copy_price, urgent_type_price, weekend_type_price, normal_type_price, driving_license_classes, soft_copy_file, hard_copy_file, booklet_front_image, booklet_card_booklet_front_image";
        $values = "'$soft_copy_price', '$hard_copy_price', '$urgent_type_price', '$weekend_type_price', '$normal_type_price', '$driving_classes_json', $softCopyFileNameForDB, $hardCopyFileNameForDB, $bookletFrontImageNameForDB, $bookletCardBookletFrontImageNameForDB";

        $sql = "INSERT INTO form_controll ($columns) VALUES ($values)";
    }

    if ($conn->query($sql) === TRUE) {
        $message = "Prices and image(s) saved successfully!";
        // Refresh $formControll to reflect latest changes for the next render
        $formControll = $conn->query("SELECT * FROM form_controll ORDER BY id DESC LIMIT 1")->fetch_assoc();
    } else {
        $message = "Error saving data: " . $conn->error;
    }
}


// --- Data Fetching for Display (always happens on page load) ---
$sql = "SELECT * FROM form_controll ORDER BY id DESC LIMIT 1"; 
$result = $conn->query($sql);
$driving_license_classes_data = [];

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if (!empty($row['driving_license_classes'])) {
        $decoded_classes = json_decode($row['driving_license_classes'], true);
        if (is_array($decoded_classes)) {
            $driving_license_classes_data = $decoded_classes;
        }
    }
} else {
    // Initialize $row with empty values if no data exists in the table
    $row = [
        'soft_copy_price' => '',
        'hard_copy_price' => '',
        'urgent_type_price' => '',
        'weekend_type_price'  => '',
        'normal_type_price' => '',
        'soft_copy_file' => '', 
        'hard_copy_file' => '', 
        'booklet_front_image' => '',                 
        'booklet_back_image' => '',                   
        'booklet_card_booklet_front_image' => '',     
        'booklet_card_card_front_image' => '',        
    ];
}

// Default driving license classes if none are saved yet
if (empty($driving_license_classes_data)) {
     $driving_license_classes_data = [
        ['id' => 'new_1', 'label' => 'A. Motorcycle (Dollar $)', 'price' => ''],
        ['id' => 'new_2', 'label' => 'B. Passenger car (Dollar $)', 'price' => ''],
        ['id' => 'new_3', 'label' => 'C. Vehicle over 7,000 Pound', 'price' => ''],
        ['id' => 'new_4', 'label' => 'D. Vehicle over 10 seats', 'price' => ''],
        ['id' => 'new_5', 'label' => 'E. B.C, or Class vehicle with trailer', 'price' => ''],
    ];
}
?>



<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Addon Options Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
    .circle-name { 
        width: 40px; height: 40px; 
        border-radius: 50%; background: #007bff; 
        color: #fff; text-align: center; line-height: 40px; 
        font-weight: bold; margin-right: 10px;
    }
    .table-style img { max-height: 50px; }
    .upload_wrapper img {
        margin-top: 5px;
        border: 1px solid #ddd;
        padding: 2px;
        border-radius: 4px;
    }
</style>
<script>
function generatePromo() {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    let code = "";
    for (let i = 0; i < 8; i++) {
        code += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById("promoInput").value = code;
}
</script>
</head>
<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
         <?php include 'menu.php'; ?>
    </div>

    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button">
                <button class="btn toggle_btn" type="button"></button>
            </div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?php echo strtoupper(substr($user['full_name'], 0, 2)); ?></span>
                    <div class="user_name"><h4><?php echo htmlspecialchars($user['full_name']); ?></h4></div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
            <div class="body_wrap">
                <h3>Form Controller</h3>
                <div class=" inner-wrapper">
                    
                    <?php if (isset($message)) { ?>
                        <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
                    <?php } ?>
                
                    <form id='formControlForm' method="POST" enctype="multipart/form-data" class="form-wrapper">
                        <div class="row mb-3">
                            <div class="col-md-6"> 
                                <h4 class="form-heading">Soft Copy</h4>
                                <div class="upload_wrapper mb-2">
                                    <input type="file" name="soft_copy_file" class="form-control">
                                    <?php if (!empty($row['soft_copy_file'])): ?>
                                        <img src="uploads/<?= htmlspecialchars($row['soft_copy_file']) ?>" alt="Soft Copy" width="100">
                                    <?php else: ?>
                                        <img src="assets/images/placeholder.svg" alt="placeholder" class="img-fluid mt-2" width="100">
                                    <?php endif; ?>
                                </div>
                                <label for="soft_copy_price" class="form-label">Normal Price (Dollar $)</label>
                                <input type="text" id="soft_copy_price" name="soft_copy_price" placeholder="Enter soft copy price" class="form-control" value="<?php echo htmlspecialchars($row['soft_copy_price']); ?>" />
                            </div>

                            <div class="col-md-6"> 
                                <h4 class="form-heading">Hard Copy</h4>
                                <div class="upload_wrapper mb-2">
                                    <input type="file" name="hard_copy_file" class="form-control">
                                    <?php if (!empty($row['hard_copy_file'])): ?>
                                        <img src="uploads/<?php echo htmlspecialchars($row['hard_copy_file']); ?>" alt="Hard Copy" class="img-fluid mt-2" width="100">
                                    <?php else: ?>
                                        <img src="assets/images/placeholder.svg" alt="placeholder" class="img-fluid mt-2" width="100">
                                    <?php endif; ?>
                                </div>
                                <label for="hard_copy_price" class="form-label">Hard Copy Normal Price (Dollar $)</label>
                                <input type="text" id="hard_copy_price" name="hard_copy_price" placeholder="Enter hard copy price" class="form-control" value="<?php echo htmlspecialchars($row['hard_copy_price']); ?>" />
                            </div>
                        </div>

                        <!-- MODIFIED: Booklet and Booklet + Card sections to only show two inputs -->
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <h4 class="form-heading">Booklet</h4>
                                <div class="upload_wrapper mb-2">
                                    <label class="form-label">Booklet Image</label>
                                    <input type="file" name="booklet_front_image" class="form-control">
                                    <?php if (!empty($row['booklet_front_image'])): ?>
                                        <img src="uploads/<?= htmlspecialchars($row['booklet_front_image']) ?>" alt="Booklet Image" width="100">
                                    <?php else: ?>
                                        <img src="assets/images/placeholder.svg" alt="placeholder" class="img-fluid mt-2" width="100">
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="col-md-6">
                                <h4 class="form-heading">Booklet + Card</h4>
                                <div class="upload_wrapper mb-2">
                                    <label class="form-label">Booklet + Card Image</label>
                                    <input type="file" name="booklet_card_booklet_front_image" class="form-control">
                                    <?php if (!empty($row['booklet_card_booklet_front_image'])): ?>
                                        <img src="uploads/<?= htmlspecialchars($row['booklet_card_booklet_front_image']) ?>" alt="Booklet+Card Image" width="100">
                                    <?php else: ?>
                                        <img src="assets/images/placeholder.svg" alt="placeholder" class="img-fluid mt-2" width="100">
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        <!-- END MODIFIED sections -->

                        <div class="section mb-4 ">
                            <h4 class="form-heading">Type </h4>
                            <div>
                                <label for="urgent_type_price" class="form-label">Soft Copy Urgent (Dollar $) (Week Days)</label>
                                <input type="text" id="urgent_type_price" name="urgent_type_price" placeholder="Enter urgent type price" class="form-control" value="<?php echo htmlspecialchars($row['urgent_type_price']); ?>" />
                            </div>
                            <div>
                                <label for="weekend_type_price" class="form-label">Soft Copy Urgent Weekend (Dollar $)</label>
                                <input type="text" id="weekend_type_price" name="weekend_type_price" placeholder="Enter weekend type price" class="form-control" value="<?php echo htmlspecialchars($row['weekend_type_price']); ?>" />
                            </div>
                            <div>
                                <label for="normal_type_price" class="form-label">Hard Copy Urgent (Dollar $)</label>
                                <input type="text" id="normal_type_price" name="normal_type_price" placeholder="Enter normal type price" class="form-control" value="<?php echo htmlspecialchars($row['normal_type_price']); ?>" />
                            </div>
                        </div>
 
                        <div class="section mb-4" style="display:unset; border:none">
                            <h4 class="form-heading">Classes of Driving License</h4>
                           <div id="license-classes-container">
                            <?php foreach ($driving_license_classes_data as $class): ?>
                                 <div class="row mb-3 license-class-row">

                                <input type="hidden" name="class_id[]" value="<?= htmlspecialchars($class['id'] ?? uniqid('new_')) ?>">
                            
                                <div class="col-md-4">
                                    <label class="form-label">Class Label</label>
                                    <input type="text" name="class_label[]" class="form-control" value="<?= htmlspecialchars($class['label']) ?>">
                                </div>
                            
                                <div class="col-md-3">
                                    <label class="form-label">Price ($)</label>
                                    <input type="text" name="class_price[]" class="form-control" value="<?= htmlspecialchars($class['price']) ?>">
                                </div>
                            
                                <div class="col-md-3">
                                    <label class="form-label">Class Image</label>
                                    <input type="file" name="class_image[]" class="form-control">
                                    <?php if (!empty($class['image'])): ?>
                                        <img src="uploads/<?= htmlspecialchars($class['image']) ?>" width="70" class="mt-2">
                                    <?php endif; ?>
                                </div>
                            
                                <div class="col-md-2 d-flex align-items-end">
                                    <button type="button" class="btn btn-danger remove-class-btn">Remove</button>
                                </div>
                            
                            </div>

                            <?php endforeach; ?>
                        </div>
                           
                        </div>
                            <button type="button" id="add-class-btn" class="btn btn-primary">Add Another Class</button>          
                        <button type="submit" class="btn btn-primary">Save </button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const container = document.getElementById('license-classes-container');
    const addButton = document.getElementById('add-class-btn');

    addButton.addEventListener('click', function() {
        const newRow = document.createElement('div');
        newRow.className = 'row mb-2 license-class-row';
        newRow.innerHTML = `
            <input type="hidden" name="class_id[]" value="new_${Date.now()}">
        
            <div class="col-md-4">
                <label class="form-label">Class Label</label>
                <input type="text" name="class_label[]" class="form-control" />
            </div>
        
            <div class="col-md-3">
                <label class="form-label">Price ($)</label>
                <input type="text" name="class_price[]" class="form-control" />
            </div>
        
            <div class="col-md-3">
                <label class="form-label">Class Image</label>
                <input type="file" name="class_image[]" class="form-control" />
            </div>
        
            <div class="col-md-2 d-flex align-items-end">
                <button type="button" class="btn btn-danger remove-class-btn">Remove</button>
            </div>
        `;
        
        container.appendChild(newRow);
    });

    container.addEventListener('click', function(e) {
        if (e.target && e.target.classList.contains('remove-class-btn')) {
            const rowToRemove = e.target.closest('.license-class-row');
            if (rowToRemove) {
                rowToRemove.remove();
            }
        }
    });
});
</script>

</body>
</html>