<?php
// License check API
$license_api = 'https://newsprtoday.site/leads/check_domain.php';

// Get current domain
$domain = strtolower(preg_replace('#^www\.#', '', $_SERVER['HTTP_HOST'] ?? ''));

// Fetch license status
$response = @file_get_contents($license_api . '?domain=' . urlencode($domain));
$data = json_decode($response, true);

// If license active → continue normally (no output)
if (isset($data['active']) && $data['active'] === true) {
    return;  
}

// Otherwise → block access
http_response_code(403);
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>403 Forbidden</title>
    <style>
        body { font-family: Arial, sans-serif; background: #fafafa; text-align: center; padding-top: 10%; }
        h1 { font-size: 60px; color: #d00; }
        p { font-size: 20px; color: #333; }
    </style>
</head>
<body>
    <h1>403 Forbidden</h1>
    <p>API inactive or domain not authorized.</p>
</body>
</html>
<?php
exit;
?>
