<?php
include '../db.php';
$conn->set_charset("utf8mb4");
session_start();
if(!isset($_SESSION['user_id'])){ header('Location: login.php'); exit; }

$user_id = $_SESSION['user_id'];
$user = $conn->query("SELECT * FROM users WHERE id=$user_id")->fetch_assoc();

if(isset($_POST['add_validity'])){
    $validity = trim($_POST['validity']);
    $hard_only = floatval($_POST['booklet_only_hard'] ?? 0);
    $hard_card = floatval($_POST['booklet_card_hard'] ?? 0);
    $soft_card = floatval($_POST['booklet_card_soft'] ?? 0);
    $soft_only = floatval($_POST['booklet_only_soft'] ?? 0);

    if($validity){
        $stmt = $conn->prepare("INSERT INTO addon_validity (validity, booklet_only_hard, booklet_card_hard, booklet_card_soft, booklet_only_soft, created_at) VALUES (?,?,?,?,?,?)");
        $t = date('Y-m-d H:i:s');
        $stmt->bind_param("sdddds",$validity,$hard_only,$hard_card,$soft_card,$soft_only,$t);
        if($stmt->execute()) header("Location: ".$_SERVER['PHP_SELF']);
        $stmt->close();
    }
}

if(isset($_POST['update_addon'])){
    $id = intval($_POST['edit_id']);
    $type = $_POST['edit_type'];
    $name = trim($_POST['edit_name']);
    $p1 = floatval($_POST['edit_p1']);
    $p2 = floatval($_POST['edit_p2']);

    $imgField = $type === 'hard' ? 'hard_image' : 'soft_image';
    $nameField = $type === 'hard' ? 'name' : 'addon_soft_product_name';
    $p1Field = $type === 'hard' ? 
        'addon_hard_booklet_card_price' : 'addon_soft_booklet_card_price';
    $p2Field = $type === 'hard' ? 
        'addon_hard_booklet_only_price' : 'addon_soft_booklet_only_price';

    if(isset($_POST['remove_image'])){
        $old = $conn->query("SELECT $imgField FROM addon_products WHERE id=$id")->fetch_assoc()[$imgField];
        if($old && file_exists("uploads/$old")) unlink("uploads/$old");
        $conn->query("UPDATE addon_products SET $imgField='' WHERE id=$id");
    }

    if(!empty($_FILES['edit_image']['name'])){
        $tmp = $_FILES['edit_image']['tmp_name'];
        $ext = strtolower(pathinfo($_FILES['edit_image']['name'], PATHINFO_EXTENSION));
        $newImg = uniqid('up_').'.'.$ext;
        move_uploaded_file($tmp,"uploads/".$newImg);
        $conn->query("UPDATE addon_products SET $imgField='$newImg' WHERE id=$id");
    }

    $conn->query("
        UPDATE addon_products SET
        $nameField='$name',
        $p1Field=$p1,
        $p2Field=$p2
        WHERE id=$id
    ");

    header("Location: ".$_SERVER['PHP_SELF']);
    exit;
}



if(isset($_POST['add_promo'])){
    $promo = trim($_POST['promo']);
    $type = $_POST['discount_type'];
    $value = floatval($_POST['discount_value']);
    $exp = $_POST['expiry_date'] ?: NULL;
    $limit = $_POST['usage_limit'] ?: NULL;

    if($promo && $value>0){
        $stmt = $conn->prepare("INSERT INTO addon_promo (promo,discount_type,discount_value,expiry_date,usage_limit) VALUES (?,?,?,?,?)");
        $stmt->bind_param("ssdsi",$promo,$type,$value,$exp,$limit);
        if($stmt->execute()) header("Location: ".$_SERVER['PHP_SELF']);
    }
}

if(isset($_GET['delete_addon'])) $conn->query("DELETE FROM addon_products WHERE id=".intval($_GET['delete_addon']));
if(isset($_GET['delete_validity'])) $conn->query("DELETE FROM addon_validity WHERE id=".intval($_GET['delete_validity']));
if(isset($_GET['delete_promo'])) $conn->query("DELETE FROM addon_promo WHERE id=".intval($_GET['delete_promo']));

$addons = $conn->query("SELECT * FROM addon_products ORDER BY id DESC");
$validities = $conn->query("SELECT * FROM addon_validity ORDER BY id DESC");
$promos = $conn->query("SELECT * FROM addon_promo ORDER BY id DESC");

$uploadDir = 'uploads/';

if(isset($_POST['add_addon'])){
    $type = $_POST['addon_type'] ?? '';
    $name = '';
    $img = '';
    $t = date('Y-m-d H:i:s');

    if(!empty($_FILES['addon_image']['name'])){
        $tmp = $_FILES['addon_image']['tmp_name'];
        $ext = strtolower(pathinfo($_FILES['addon_image']['name'], PATHINFO_EXTENSION));
        $size = $_FILES['addon_image']['size'];
        if(in_array($ext,['jpg','jpeg','png','gif','svg']) && $size <= 300*1024){
            $img = uniqid($type.'_').'.'.$ext;
            move_uploaded_file($tmp,$uploadDir.$img);
        }
    }

    if($type === 'hard'){
        $name = trim($_POST['addon_name']);
        $p1 = floatval($_POST['addon_hard_booklet_card_price'] ?? 0);
        $p2 = floatval($_POST['addon_hard_booklet_only_price'] ?? 0);
        if($name && ($p1>0 || $p2>0)){
            $stmt = $conn->prepare("INSERT INTO addon_products (name,addon_hard_booklet_card_price,addon_hard_booklet_only_price,hard_image,created_at) VALUES (?,?,?,?,?)");
            $stmt->bind_param("sddss",$name,$p1,$p2,$img,$t);
            if($stmt->execute()) header("Location: ".$_SERVER['PHP_SELF']);
        }
    }

    if($type === 'soft'){
        $name = trim($_POST['addon_soft_product_name']);
        $p1 = floatval($_POST['addon_soft_booklet_card_price'] ?? 0);
        $p2 = floatval($_POST['addon_soft_booklet_only_price'] ?? 0);
        if($name && ($p1>0 || $p2>0)){
            $stmt = $conn->prepare("INSERT INTO addon_products (addon_soft_product_name,addon_soft_booklet_card_price,addon_soft_booklet_only_price,soft_image,created_at) VALUES (?,?,?,?,?)");
            $stmt->bind_param("sddss",$name,$p1,$p2,$img,$t);
            if($stmt->execute()) header("Location: ".$_SERVER['PHP_SELF']);
        }
    }
}

function getAddonImage($row,$type){
    $img = $type==='hard' ? $row['hard_image'] : $row['soft_image'];
    return (!empty($img) && file_exists("uploads/$img")) ? $img : null;
}
?>


<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Addon Options Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
.circle-name { width: 40px; height: 40px; border-radius: 50%; background: #007bff; color: #fff; text-align: center; line-height: 40px; font-weight: bold; margin-right: 10px; }
.table-style img { max-height: 50px; }
/* Added basic styling for form elements for better layout */
#addonForm div, #addonForm select, #addonForm input[type=file], #addonForm button {
    margin-bottom: 10px;
}
#hardFields, #softFields {
    display: flex; /* Use flex for horizontal layout if desired */
    flex-direction: column; /* Stack fields vertically */
    gap: 10px; /* Add space between fields */
    padding: 10px;
    border: 1px solid #ccc;
    margin-top: 10px;
    border-radius: 5px;
}
#hardFields.hidden, #softFields.hidden {
    display: none !important;
}

</style>
<script>
function generatePromo() {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    let code = "";
    for (let i = 0; i < 8; i++) {
        code += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById("promoInput").value = code;
}

document.addEventListener("DOMContentLoaded", function() {
    const addonTypeSelect = document.getElementById('addon_type');
    const hardFields = document.getElementById('hardFields'); // Corrected ID reference
    const softFields = document.getElementById('softFields'); // Corrected ID reference

    function toggleFields() {
        const type = addonTypeSelect.value;
        hardFields.style.display = (type === 'hard') ? 'block' : 'none'; // Use 'block' or other appropriate display value
        softFields.style.display = (type === 'soft') ? 'block' : 'none'; // Use 'block' or other appropriate display value
    }

    if (addonTypeSelect) {
        // Initialize display based on current selection (if any)
        toggleFields();

        // Add change event listener
        addonTypeSelect.addEventListener('change', toggleFields);
    }
});
</script>



</head>
<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
        <?php include 'menu.php'; ?>
    </div>

    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button"><button class="btn toggle_btn" type="button"></button></div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?= strtoupper(substr($user['full_name'], 0, 2)) ?></span>
                    <div class="user_name"><h4><?= htmlspecialchars($user['full_name']) ?></h4></div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
            <!-- Add-on Form -->
            <div class="mb-4 p-3 border rounded">
                <h4>Add Add-on</h4>
                <?php
                // Display success/error messages specific to the Add-on form submission
                if (!empty($successAddon)) echo "<div class='alert alert-success'>$successAddon</div>";
                if (!empty($errorAddon)) echo "<div class='alert alert-danger'>$errorAddon</div>";
                ?>
                <form method="post" enctype="multipart/form-data" id="addonForm">
                    <div class="mb-2">
                        <label for="addon_type" class="form-label">Select Add-on Type</label>
                        <select name="addon_type" id="addon_type" class="form-select" required>
                            <option value="">-- Select Type --</option>
                            <option value="hard" <?= (isset($_POST['addon_type']) && $_POST['addon_type'] == 'hard') ? 'selected' : '' ?>>Hard Copy</option>
                            <option value="soft" <?= (isset($_POST['addon_type']) && $_POST['addon_type'] == 'soft') ? 'selected' : '' ?>>Soft Copy</option>
                        </select>
                    </div>

                    <!-- Hard Copy Fields -->
                    <div id="hardFields" style="display: none;">
                        <label class="fw-bold">Hard Copy Details</label>
                        <input type="text" name="addon_name" class="form-control" placeholder="Hard Copy Name" value="<?= htmlspecialchars($_POST['addon_name'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_hard_booklet_card_price" class="form-control" placeholder="Booklet + Card Price" value="<?= htmlspecialchars($_POST['addon_hard_booklet_card_price'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_hard_booklet_only_price" class="form-control" placeholder="Booklet Only Price" value="<?= htmlspecialchars($_POST['addon_hard_booklet_only_price'] ?? '') ?>">
                    </div>

                    <!-- Soft Copy Fields -->
                    <div id="softFields" style="display: none;">
                        <label class="fw-bold">Soft Copy Details</label>
                        <input type="text" name="addon_soft_product_name" class="form-control" placeholder="Soft Copy Name" value="<?= htmlspecialchars($_POST['addon_soft_product_name'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_soft_booklet_card_price" class="form-control" placeholder="Soft Booklet + Card Price" value="<?= htmlspecialchars($_POST['addon_soft_booklet_card_price'] ?? '') ?>">
                        <input type="number" step="0.01" name="addon_soft_booklet_only_price" class="form-control" placeholder="Soft Booklet Only Price" value="<?= htmlspecialchars($_POST['addon_soft_booklet_only_price'] ?? '') ?>">
                    </div>

                    <div class="mb-2">
                         <label for="addon_image" class="form-label">Image (Max 300KB, jpg, png, gif, svg)</label>
                        <input type="file" name="addon_image" id="addon_image" class="form-control" accept="image/*">
                    </div>

                    <button type="submit" name="add_addon" class="btn btn-primary mt-2">Add Add-on</button>
                </form>


                <!-- Add-ons Table -->
                <h5 class="mt-4">Current Add-ons</h5>

                <h6 class="mt-3">Hard Copy Add-ons</h6>
                <table class="table table-bordered table-striped">
                    <thead>
                        <tr><th>Name</th><th>Booklet+Card Price</th><th>Booklet Only Price</th><th>Image</th><th>Action</th></tr>
                    </thead>
                    <tbody>
                    <?php
                    // Fetch only rows that are clearly hard copies
                    $hard_addons = $conn->query("SELECT * FROM addon_products WHERE name IS NOT NULL AND name != '' ORDER BY id DESC");
                    if ($hard_addons->num_rows > 0):
                        while($row = $hard_addons->fetch_assoc()):
                    ?>
                        <tr>
                            <td><?= htmlspecialchars($row['name']) ?></td>
                            <td><?= $row['addon_hard_booklet_card_price'] > 0 ? '$'.number_format($row['addon_hard_booklet_card_price'],2) : '-' ?></td>
                            <td><?= $row['addon_hard_booklet_only_price'] > 0 ? '$'.number_format($row['addon_hard_booklet_only_price'],2) : '-' ?></td>
                            <td>
                                <?php $img = getAddonImage($row, 'hard'); ?>
                                <?php if($img): ?>
                                    <img src="uploads/<?= htmlspecialchars($img) ?>" alt="Hard Addon Image" style="height:50px">
                                <?php else: ?>No Image<?php endif; ?>
                            </td>
                            <td>
                                <button type="button" class="btn btn-primary btn-sm"
    onclick='editAddon(JSON.parse(this.dataset.row))'
    data-row='<?= json_encode($row, JSON_HEX_APOS | JSON_HEX_QUOT) ?>'>
    Edit
</button>
<a href="?delete_addon=<?= $row['id'] ?>" class="btn btn-danger btn-sm">Delete</a>

                            </td>
                        </tr>
                    <?php endwhile;
                     else: ?>
                         <tr><td colspan="5" class="text-center">No Hard Copy add-ons found.</td></tr>
                    <?php endif; ?>
                    </tbody>
                </table>

                <h6 class="mt-3">Soft Copy Add-ons</h6>
                <table class="table table-bordered table-striped">
                     <thead>
                        <tr><th>Name</th><th>Booklet+Card Price</th><th>Booklet Only Price</th><th>Image</th><th>Action</th></tr>
                    </thead>
                    <tbody>
                    <?php
                    $soft_addons = $conn->query("
                            SELECT id, addon_soft_product_name, addon_soft_booklet_card_price, 
                                   addon_soft_booklet_only_price, soft_image 
                            FROM addon_products 
                            WHERE addon_soft_product_name!='' 
                            ORDER BY id DESC
                        ");
                    
                     if ($soft_addons->num_rows > 0):
                         while($row = $soft_addons->fetch_assoc()):
                    ?>
                        <tr>
                            <td><?= htmlspecialchars($row['addon_soft_product_name']) ?></td>
                             <td><?= $row['addon_soft_booklet_card_price'] > 0 ? '$'.number_format($row['addon_soft_booklet_card_price'],2) : '-' ?></td>
                            <td><?= $row['addon_soft_booklet_only_price'] > 0 ? '$'.number_format($row['addon_soft_booklet_only_price'],2) : '-' ?></td>
                            <td>
                                <?php $img = getAddonImage($row, 'soft'); ?>
                                <?php if($img): ?>
                                    <img src="uploads/<?= htmlspecialchars($img) ?>" alt="Soft Addon Image" style="height:50px">
                                <?php else: ?>No Image<?php endif; ?>
                            </td>
                            <td>
                             <button type="button" class="btn btn-primary btn-sm"
    onclick='editAddon(JSON.parse(this.dataset.row))'
    data-row='<?= json_encode($row, JSON_HEX_APOS | JSON_HEX_QUOT) ?>'>
    Edit
</button>


<a href="?delete_addon=<?= $row['id'] ?>" class="btn btn-danger btn-sm">Delete</a>
                            </td>
                        </tr>
                    <?php endwhile;
                     else: ?>
                         <tr><td colspan="5" class="text-center">No Soft Copy add-ons found.</td></tr>
                     <?php endif; ?>
                    </tbody>
                </table>

            </div>

            <!-- Validity Section -->
            <div class="mb-4 p-3 border rounded">
           <div class="mb-4 p-3 border rounded">
                <h4>Add Validity Option</h4>
                <?php if(isset($successValidity)) echo "<div class='alert alert-success'>$successValidity</div>"; ?>
                <?php if(isset($errorValidity)) echo "<div class='alert alert-danger'>$errorValidity</div>"; ?>

                <!-- Updated Form for Validity -->
                <form method="post" class="row g-2 mb-3 align-items-end">
                    <div class="col-md-3">
                        <label for="validity_name_input" class="form-label">Validity Name</label>
                        <input type="text" id="validity_name_input" name="validity" class="form-control" placeholder="e.g., 1 Month, 3 Months" required value="<?= htmlspecialchars($_POST['validity'] ?? '') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_only_hard_input" class="form-label">Booklet Only (Hard)</label>
                        <!-- Use type="number" and step="0.01" for price inputs -->
                        <input type="number" step="0.01" id="booklet_only_hard_input" name="booklet_only_hard" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_only_hard'] ?? '0.00') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_card_hard_input" class="form-label">Booklet Card (Hard)</label>
                        <input type="number" step="0.01" id="booklet_card_hard_input" name="booklet_card_hard" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_card_hard'] ?? '0.00') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_card_soft_input" class="form-label">Booklet Card (Soft)</label>
                        <input type="number" step="0.01" id="booklet_card_soft_input" name="booklet_card_soft" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_card_soft'] ?? '0.00') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="booklet_only_soft_input" class="form-label">Booklet Only (Soft)</label>
                        <input type="number" step="0.01" id="booklet_only_soft_input" name="booklet_only_soft" class="form-control" placeholder="Price" value="<?= htmlspecialchars($_POST['booklet_only_soft'] ?? '0.00') ?>">
                    </div>
                    <div class="col-12"> <!-- Button on its own line for better layout -->
                        <button type="submit" name="add_validity" class="btn btn-primary">Add Validity Option</button>
                    </div>
                </form>

                <table class="table table-bordered">
                    <thead>
                        <tr> 
                            <th>Validity Name</th> 
                            <th>Booklet Only (Hard)</th>
                            <th>Booklet Card (Hard)</th>
                            <th>Booklet Card (Soft)</th>
                            <th>Booklet Only (Soft)</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php
                    // $validities is already fetched with SELECT * FROM addon_validity
                    if ($validities->num_rows > 0) { // Check if there are any rows to display
                        while($row = $validities->fetch_assoc()):
                    ?>
                        <tr> 
                            <td><?= htmlspecialchars($row['validity']) ?></td> 
                            <!-- Format prices, display '-' if 0 or not set -->
                            <td><?= $row['booklet_only_hard'] > 0 ? '$'.number_format($row['booklet_only_hard'], 2) : '-' ?></td>
                            <td><?= $row['booklet_card_hard'] > 0 ? '$'.number_format($row['booklet_card_hard'], 2) : '-' ?></td>
                            <td><?= $row['booklet_card_soft'] > 0 ? '$'.number_format($row['booklet_card_soft'], 2) : '-' ?></td>
                            <td><?= $row['booklet_only_soft'] > 0 ? '$'.number_format($row['booklet_only_soft'], 2) : '-' ?></td>
                            <td><a href="?delete_validity=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure you want to delete this validity option?')">Delete</a></td>
                        </tr>
                    <?php
                        endwhile;
                    } else { // If no rows were fetched
                    ?>
                        <tr>
                            <td colspan="8" class="text-center">No validity options found.</td>
                        </tr>
                    <?php } ?>
                    </tbody>
                </table>
            </div>

            <!-- Promo Section -->
            <div class="mb-4 p-3 border rounded">
                <h4>Add Promo Code</h4>
                <?php if(isset($successPromo)) echo "<div class='alert alert-success'>$successPromo</div>"; ?>
                <?php if(isset($errorPromo)) echo "<div class='alert alert-danger'>$errorPromo</div>"; ?>
                <form method="post" class="row g-2 mb-2 align-items-end">
                    <div class="col-md-3">
                        <label for="promoInput" class="form-label">Promo Code</label>
                        <div class="d-flex">
                            <input type="text" id="promoInput" name="promo" class="form-control" placeholder="Promo Code" required value="<?= htmlspecialchars($_POST['promo'] ?? '') ?>">
                            <button type="button" class="btn btn-secondary btn-sm" onclick="generatePromo()">Generate</button>
                        </div>
                    </div>
                    <div class="col-md-3">
                        <label for="discount_type" class="form-label">Discount Type</label>
                        <select name="discount_type" id="discount_type" class="form-select">
                            <option value="percent" <?= (isset($_POST['discount_type']) && $_POST['discount_type'] == 'percent') ? 'selected' : '' ?>>Percent (%)</option>
                            <option value="fixed" <?= (isset($_POST['discount_type']) && $_POST['discount_type'] == 'fixed') ? 'selected' : '' ?>>Fixed Amount</option>
                        </select>
                    </div>
                    <div class="col-md-2">
                        <label for="discount_value" class="form-label">Discount Value</label>
                        <input type="number" step="0.01" id="discount_value" name="discount_value" class="form-control" placeholder="Value" required value="<?= htmlspecialchars($_POST['discount_value'] ?? '') ?>">
                    </div>
                    <div class="col-md-2">
                        <label for="expiry_date" class="form-label">Expiry Date</label>
                        <input type="date" id="expiry_date" name="expiry_date" class="form-control" value="<?= htmlspecialchars($_POST['expiry_date'] ?? '') ?>">
                    </div>
                     <div class="col-md-12 mt-2">
                         <button type="submit" name="add_promo" class="btn btn-primary">Add Promo</button>
                    </div>
                </form>

                <table class="table table-bordered mt-3">
                    <thead>
                        <tr>
                            <th>ID</th><th>Promo Code</th><th>Discount Type</th><th>Discount Value</th><th>Expiry Date</th><th>Usage Limit</th><th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php while($row=$promos->fetch_assoc()): ?>
                        <tr>
                            <td><?= $row['id'] ?></td>
                            <td><?= htmlspecialchars($row['promo']) ?></td>
                            <td><?= ucfirst($row['discount_type']) ?></td>
                            <td><?= $row['discount_type']=='percent'? number_format($row['discount_value'], 2).'%':'$'.number_format($row['discount_value'],2) ?></td>
                            <td><?= $row['expiry_date']?htmlspecialchars($row['expiry_date']):'-' ?></td>
                             <td><?= $row['usage_limit'] ?? '-' ?></td>
                            <td><a href="?delete_promo=<?= $row['id'] ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete Promo?')">Delete</a></td>
                        </tr>
                    <?php endwhile; ?>
                    </tbody>
                </table>
            </div>

        </div>
    </div>
</div>

<div class="modal fade" id="editAddonModal" tabindex="-1">
  <div class="modal-dialog">
    <div class="modal-content">
      <form method="post" enctype="multipart/form-data">
        <div class="modal-header">
          <h5 class="modal-title">Edit Add-on</h5>
          <button class="btn-close" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          
          <input type="hidden" name="edit_id" id="edit_id">
          <input type="hidden" name="edit_type" id="edit_type">

          <label>Name</label>
          <input type="text" class="form-control" id="edit_name" name="edit_name">

          <label class="mt-2">Booklet + Card Price</label>
          <input type="number" step="0.01" class="form-control" id="edit_p1" name="edit_p1">

          <label class="mt-2">Booklet Only Price</label>
          <input type="number" step="0.01" class="form-control" id="edit_p2" name="edit_p2">

          <div class="mt-3">
            <label>Current Image</label>
            <div id="edit_img_box"></div>

            <div class="form-check mt-2">
              <input class="form-check-input" type="checkbox" name="remove_image" id="remove_image" value="1">
              <label class="form-check-label">Remove Image</label>
            </div>
          </div>

          <label class="mt-3">Replace Image</label>
          <input type="file" name="edit_image" class="form-control">

        </div>

        <div class="modal-footer">
          <button class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
          <button class="btn btn-primary" name="update_addon">Update</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script>
function editAddon(row){
    const modal = new bootstrap.Modal(document.getElementById('editAddonModal'));

    let type = row.addon_soft_product_name ? 'soft' : 'hard';
    let img = type === 'hard' ? row.hard_image : row.soft_image;

    document.getElementById('edit_id').value = row.id;
    document.getElementById('edit_type').value = type;

    document.getElementById('edit_name').value =
        type === 'hard' ? row.name : row.addon_soft_product_name;

    document.getElementById('edit_p1').value =
        type === 'hard' ? row.addon_hard_booklet_card_price : row.addon_soft_booklet_card_price;

    document.getElementById('edit_p2').value =
        type === 'hard' ? row.addon_hard_booklet_only_price : row.addon_soft_booklet_only_price;

    document.getElementById('edit_img_box').innerHTML =
        img ? `<img src="uploads/${img}" style="height:80px;border-radius:6px;">`
            : `No image`;

    document.getElementById('remove_image').checked = false;
    modal.show();
}
</script>


</body>
</html>