<?php
// Enable error reporting for debugging
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Database connection details
$host = "localhost";
$username = "bdmaco_dhlet";
$password = "Dhlet@123";
$dbname = "bdmaco_dhl";

// Create a new MySQL connection
$conn = new mysqli($host, $username, $password, $dbname);

// Check if the connection is successful
if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
} else {
    echo "Database connected successfully!<br>";
}

// Function to handle the file upload and data insertion
function uploadFileAndInsertData($filePath) {
    global $conn;

    // Open the uploaded file and read the data
    $data = file($filePath);

    if (!$data) {
        echo "Error: Could not read the file.<br>";
        return;
    }

    // Loop through each line in the file
    foreach ($data as $line) {
        // Split the line by tab character to get country, postalCode, and city
        $parts = explode("\t", trim($line));

        // Debug: Show the line contents
        echo "Processing line: $line<br>";

        // Ensure the line has exactly 3 parts
        if (count($parts) >= 3) {
            $country = $parts[0];
            $postalCode = $parts[1];
            $city = $parts[2];

            // Debug: Show the data to be inserted
            echo "Inserting data: $country | $postalCode | $city<br>";

            // Prepare the SQL query to insert data into the database
            $sql = "INSERT INTO postal_city (country_code, postal_code, city_name) VALUES (?, ?, ?)";
            $stmt = $conn->prepare($sql);

            // Check if the statement was prepared successfully
            if ($stmt === false) {
                echo "Error preparing statement: " . $conn->error . "<br>";
                continue; // Skip this line and move to the next one
            }

            // Bind parameters to the statement
            $stmt->bind_param("sss", $country, $postalCode, $city);

            // Execute the query and check for errors
            if (!$stmt->execute()) {
                echo "Error executing query: " . $stmt->error . "<br>";
            } else {
                echo "Data inserted successfully: $country | $postalCode | $city<br>";
            }

            // Close the statement
            $stmt->close();
        } else {
            echo "Skipping invalid line: $line<br>";
        }
    }

    echo "Data upload finished!<br>";
}

// Handle file upload when the form is submitted
if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_FILES['dataFile'])) {
    // Debugging: Check the contents of $_FILES
    echo "<pre>";
    print_r($_FILES); // Print the contents of $_FILES to debug the upload
    echo "</pre>";

    // Get the file details
    $fileTmpPath = $_FILES['dataFile']['tmp_name'];
    $fileName = $_FILES['dataFile']['name'];
    $fileExt = pathinfo($fileName, PATHINFO_EXTENSION);

    // Check for upload errors
    if ($_FILES['dataFile']['error'] !== UPLOAD_ERR_OK) {
        die("Error uploading file. Error code: " . $_FILES['dataFile']['error']);
    }

    // Check if the file is a valid .txt file
    if ($fileExt !== 'txt') {
        die("Error: Only .txt files are allowed!");
    }

    // Define where to move the uploaded file
    $uploadDir = 'uploads/';
    if (!is_dir($uploadDir)) {
        mkdir($uploadDir, 0777, true); // Create the directory if it doesn't exist
    }
    $uploadPath = $uploadDir . $fileName;

    // Debug: Check if the file is being uploaded to the correct path
    echo "Temporary file path: " . $_FILES['dataFile']['tmp_name'] . "<br>";
    echo "Upload directory path: " . $uploadPath . "<br>";

    // Move the file to the target directory
    if (move_uploaded_file($fileTmpPath, $uploadPath)) {
        echo "File uploaded successfully!<br>";
        // Call the function to insert the data into the database
        uploadFileAndInsertData($uploadPath);
    } else {
        echo "Error: There was an issue uploading the file.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Upload Postal Data File</title>
</head>
<body>

<h2>Upload Postal Data File</h2>
<form action="" method="POST" enctype="multipart/form-data">
    <label for="dataFile">Choose .txt file to upload:</label>
    <input type="file" name="dataFile" id="dataFile" accept=".txt" required>
    <button type="submit">Upload File</button>
</form>

</body>
</html>
