<?php
include 'session.php';

?>
<!DOCTYPE html>
<html>

<head>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Step 1 - Applicant's Details</title>
  <?php include('link.php'); ?>
  
  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.min.js"></script>
<link rel="stylesheet" href="https://code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">
<style>
    /* Style for the new error message */
    #location-error {
        color: #D8000C; /* Red color for error */
        font-size: 0.9em;
        margin-top: 5px;
        display: none; /* Hidden by default */
    }
</style>
</head>

<body>
  <?php include('header.php'); ?>

  <section class="step-section steplicence">
    <div class="step-header">
      <h1>Apply for International Driving License</h1>
      <p>Most accepted at the global level & trusted by travellers all around the world</p>
    </div>

  <div class="step-progress">
    <div class="step active"><span class="number">01</span><span class="label">Applicant's Details</span></div>
    <div class="step "><span class="number">02</span><span class="label">Choose Plan</span></div>
    <div class="step"><span class="number">03</span><span class="label">Review</span></div>
    <div class="step"><span class="number">04</span><span class="label">Payment</span></div>
  </div>
  </section>


  <div class="licenceform">
    <div class="container">


      <div class="main-form-container">

        <div class="form-container">
          <h2>Applicant’s Details</h2>
          <!-- Added an ID to the form for easier selection -->
          <form method="post" action="save_step1.php" id="applicant-form">
            <div class="licenceform-row">
              <div class="formfield">
                <label>First Name *</label>
                <input type="text" name="first_name" required>
              </div>
              <div class="formfield">
                <label>Last Name *</label>
                <input type="text" name="last_name" required>
              </div>
              <div class="formfield">
                <label>Email *</label>
                <input type="email" name="email" required>
              </div>
              <div class="formfield">
                <label>WhatsApp Number *</label>
                <input type="text" name="whatsapp" required>
              </div>
              <div class="formfield">
                <label>Date of Birth *</label>
                <div style="display: flex; gap: 10px;">
                  <input type="text" name="dob_month" placeholder="Month" required>
                  <input type="text" name="dob_day" placeholder="Day" required>
                  <input type="text" name="dob_year" placeholder="Year" required>
                </div>
              </div>
              <div class="formfield" style="display:none;">
                <label>Place of Birth *</label>
                <select id="birth" name="birth_place">
                  <option value="" disabled selected>Select Country</option>
                </select>
                <input type="hidden" id="birth_hidden" name="birth_code">

              </div>
         
                <div class="formfield full-field">
                  <label>Street Address *</label>
                  <input type="text" name="street" required>
                </div>
                
                 <div class="formfield full-field">
                  <label>Permanent Place of Residence *</label>
                  <select id="country" name="country_name" required><option value="" disabled selected>Select Country</option></select>
                    <input type="hidden" id="country_hidden" name="country_code" placeholder="Select Country">
                </div>
                
                <div class="formfield full-field">
                  <label>ZIP *</label>
                  <input type="text" id="zip" name="zip" required>
                   <!-- NEW: Error message container -->
                  <p id="location-error"></p>
                </div>

                <div class="formfield full-field">
                  <label>State/Region/Province *</label><br>
                    <input type="text" id="state" name="state" required>
                </div>
              
                <div class="formfield full-field">
                  <label>City *</label>
                  <!-- We make it readonly again so user cannot change it, but validation is now handled by JS -->
                  <input type="text" id="city" name="city" readonly required>
                </div>

              <div class="formfield" style="display:none">
                <label>Gender *</label>
                <div class="gender-group">
                  <label class="gender-box active" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Male" checked>
                    <img style="margin-bottom:6px;" src="assets/images/male.svg"><br> Male
                  </label>
                  <label class="gender-box" onclick="selectGender(this)">
                    <input type="radio" name="gender" value="Female">
                    <img style="margin-bottom:6px;" src="assets/images/female.svg"><br> Female
                  </label>
                </div>
              </div>
            </div>

            <button type="submit" class="btn secondary-btn-circle">Verify & Continue</button>
          </form>
        </div>

        <div class="global-container">
          <?php include('stats-card.php'); ?>
        </div>

      </div>


    </div>
  </div>

  <?php include('footer.php'); ?>

  <script>
    function selectGender(el) {
      document.querySelectorAll('.gender-box').forEach(box => box.classList.remove('active'));
      el.classList.add('active');
      el.querySelector('input').checked = true;
    }
  </script>

<!-- =================== NEW UPDATED SCRIPT =================== -->
<script>
document.addEventListener("DOMContentLoaded", function () {
  const applicantForm = document.getElementById("applicant-form");
  const countrySelect = document.getElementById("country");
  const zipInput = document.getElementById("zip");
  const cityInput = document.getElementById("city"); 
  const stateInput = document.getElementById("state"); // Corrected to stateInput
  const locationError = document.getElementById("location-error");

  let debounceTimeout; // Timer for instant search

  // Function to fetch location data
  const fetchLocation = () => {
    const zip = zipInput.value.trim();
    const country = countrySelect.value;
    
    // Clear previous results and errors
    cityInput.value = '';
    stateInput.value = '';
    locationError.style.display = 'none';

    // Don't search if zip or country is empty
    if (!zip || !country) return;

    // Show a loading message
    locationError.textContent = 'Searching...';
    locationError.style.display = 'block';

    $.getJSON(`get_location.php?zip=${zip}&country=${country}`, function (res) {
      if (res.city && res.city.trim() !== '') {
        cityInput.value = res.city;
        stateInput.value = res.state || '';
        locationError.style.display = 'none'; // Hide on success
      } else {
        // City not found
        locationError.textContent = 'City not found for this ZIP code. Please check.';
        locationError.style.display = 'block';
      }
    }).fail(function () {
      // API call failed
      locationError.textContent = 'Failed to fetch location. Please try again.';
      locationError.style.display = 'block';
    });
  };

  // Listen for typing in the ZIP field (instant search)
  zipInput.addEventListener("input", function () {
    clearTimeout(debounceTimeout); // Reset timer on each keystroke
    debounceTimeout = setTimeout(fetchLocation, 500); // Wait 500ms after user stops typing
  });
  
  // Also fetch when country is changed
  countrySelect.addEventListener("change", fetchLocation);

  // *** THE MOST IMPORTANT PART: VALIDATE BEFORE SUBMITTING ***
  applicantForm.addEventListener("submit", function (event) {
    // Check if the city field is empty
    if (cityInput.value.trim() === '') {
      // Prevent the form from submitting
      event.preventDefault(); 
      
      // Show error and alert the user
      locationError.textContent = 'City is required. Please enter a valid ZIP code to find your city.';
      locationError.style.display = 'block';
      alert('City is a required field. Please provide a valid ZIP code to continue.');
      zipInput.focus(); // Put cursor back to the zip input
    }
  });

  // The rest of your script for country dropdowns can go here...
  const birthSelect = document.getElementById("birth");
  const countryHidden = document.getElementById("country_hidden");
  const birthHidden = document.getElementById("birth_hidden");
  fetch("get_countries.php")
    .then(res => res.json())
    .then(countries => {
      countries.forEach(c => {
        const option1 = document.createElement("option");
        option1.value = c.code;
        option1.textContent = c.name;
        countrySelect.appendChild(option1.cloneNode(true));
        birthSelect.appendChild(option1.cloneNode(true));
      });
    });
  countrySelect.addEventListener("change", () => { countryHidden.value = countrySelect.value; });
  birthSelect.addEventListener("change", () => { birthHidden.value = birthSelect.value; });
});
</script>

  <?php include('footerscript.php'); ?>
</body>
</html>