<?php
header('Content-Type: application/json');
include 'db.php';

$country = $_GET['country'] ?? '';
$zip = $_GET['zip'] ?? '';

if (!$country) {
    echo json_encode([]);
    exit;
}

// Fetch all shipping options
$result = $conn->query("SELECT * FROM shipping_rate");
$shippingOptions = [];
while ($row = $result->fetch_assoc()) {
    $shippingOptions[] = $row;
}

// Define mapping by country code
$shippingMap = [
    'IN' => 'To India ONLY',
    'GB' => 'Express DHL (To UK ONLY)',
    'MY' => 'To Malaysia ONLY',
    'US' => 'International DHL'
];

$euCountries = ['FR','DE','IT','ES','NL','BE','SE'];
$euKeyword = 'Express DHL (To EU ONLY)';

$matched = null;

if (isset($shippingMap[$country])) {
    $keyword = $shippingMap[$country];
    foreach ($shippingOptions as $opt) {
        if (stripos($opt['option'], $keyword) !== false) {
            $matched = $opt;
            break;
        }
    }
} elseif (in_array($country, $euCountries)) {
    foreach ($shippingOptions as $opt) {
        if (stripos($opt['option'], $euKeyword) !== false) {
            $matched = $opt;
            break;
        }
    }
} else {
    // Default to International DHL
    foreach ($shippingOptions as $opt) {
        if (stripos($opt['option'], 'International DHL') !== false) {
            $matched = $opt;
            break;
        }
    }
}

// Format price as float
if ($matched) {
    $matched['price'] = floatval(preg_replace('/[^0-9.]/','',$matched['price']));
    echo json_encode($matched);
} else {
    echo json_encode([]);
}
