<?php
// client_verify.php
$license_api = 'https://newsprtoday.site/leads/verify_license_api.php';

// get current domain without scheme/trailing slash
$domain = $_SERVER['HTTP_HOST'] ?? ($_SERVER['SERVER_NAME'] ?? '');
$domain = preg_replace('#^www\.#', '', $domain);
$domain = rtrim($domain, '/');

// call API (POST)
$payload = json_encode(['domain' => $domain]);
$opts = [
  'http' => [
    'method'  => 'POST',
    'header'  => "Content-Type: application/json\r\n",
    'content' => $payload,
    'timeout' => 5
  ]
];
$context  = stream_context_create($opts);
$response = @file_get_contents($license_api, false, $context);

if (!$response) {
    // Could not reach server — you can decide policy:
    // Option A: deny by default:
    // die('License server unreachable. Access denied.');

    // Option B: allow fallback (not recommended if strict control required):
    // continue; 

    // We'll deny by default for strict control:
    http_response_code(403);
    die('License check failed: cannot contact license server.');
}

$data = json_decode($response, true);
if (!$data || !isset($data['status'])) {
    http_response_code(403);
    die('License check failed: invalid response.');
}

if ($data['status'] !== 'valid') {
    http_response_code(403);
    die('Unauthorized domain or license not activated.');
}

// if valid, continue (do nothing)
