<?php
header('Content-Type: application/json');
include $_SERVER['DOCUMENT_ROOT'] . '/drive/db.php';

try {
  // Collect POST data
  $soft_copy_price = $_POST['soft_copy_price'] ?? '';
  $hard_copy_price = $_POST['hard_copy_price'] ?? '';
  $urgent_type_price = $_POST['urgent_type_price'] ?? '';
  $normal_type_price = $_POST['normal_type_price'] ?? '';
  $motorcyle_price = $_POST['motorcyle_price'] ?? '';
  $passenger_car_price = $_POST['passenger_car_price'] ?? '';
  $vehicle_over_price = $_POST['vehicle_over_price'] ?? '';
  $vehicle_over_seats_price = $_POST['vehicle_over_seats_price'] ?? '';
  $ebc_price = $_POST['ebc_price'] ?? '';
  $product_price = $_POST['product_price'] ?? '';

  // Check if a record with ID = 1 exists
  $checkStmt = $conn->prepare("SELECT id FROM form_controll WHERE id = 1");
  $checkStmt->execute();
  $checkStmt->store_result();

  if ($checkStmt->num_rows > 0) {
    // Record exists → UPDATE
    $stmt = $conn->prepare("UPDATE form_controll SET 
            soft_copy_price=?, 
            hard_copy_price=?, 
            urgent_type_price=?, 
            normal_type_price=?, 
            motorcyle_price=?, 
            passenger_car_price=?, 
            vehicle_over_price=?, 
            vehicle_over_seats_price=?, 
            ebc_price=?, 
            product_price=? 
            WHERE id = 1");

    $stmt->bind_param(
      "ssssssssss",
      $soft_copy_price,
      $hard_copy_price,
      $urgent_type_price,
      $normal_type_price,
      $motorcyle_price,
      $passenger_car_price,
      $vehicle_over_price,
      $vehicle_over_seats_price,
      $ebc_price,
      $product_price
    );

    $stmt->execute();
    $message = 'Record updated successfully';
  } else {
    // No record → INSERT
    $stmt = $conn->prepare("INSERT INTO form_controll (
            soft_copy_price,
            hard_copy_price,
            urgent_type_price,
            normal_type_price,
            motorcyle_price,
            passenger_car_price,
            vehicle_over_price,
            vehicle_over_seats_price,
            ebc_price,
            product_price
        ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param(
      "ssssssssss",
      $soft_copy_price,
      $hard_copy_price,
      $urgent_type_price,
      $normal_type_price,
      $motorcyle_price,
      $passenger_car_price,
      $vehicle_over_price,
      $vehicle_over_seats_price,
      $ebc_price,
      $product_price
    );

    $stmt->execute();
    $message = 'Record inserted successfully';
  }

  echo json_encode(['status' => 'success', 'message' => $message]);
} catch (Exception $e) {
  echo json_encode(['status' => 'error', 'message' => $e->getMessage()]);
}
