<?php
header('Content-Type: application/json');
include 'db.php';

$zip = $_GET['zip'] ?? '';
$country = strtoupper($_GET['country'] ?? '');

if (!$zip || !$country) {
    echo json_encode(['error' => 'Missing ZIP or Country']);
    exit;
}

// Normalize postal codes (remove spaces for Canada, US etc.)
$zip = str_replace(' ', '', $zip);

$city = '';
$state = '';

// --- 1. DHL API ---
$dhlKey = 'pAhLmsinCbAg43j0Cn7PKVkZZy4BO41l';
$dhlEndpoint = "https://api.dhl.com/location-finder/v1/find-by-address?countryCode=$country&postalCode=$zip";

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $dhlEndpoint,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => [
        "DHL-API-Key: $dhlKey",
        "Accept: application/json"
    ],
    CURLOPT_TIMEOUT => 5,
]);
$response = curl_exec($ch);
$httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($httpCode === 200 && $response) {
    $data = json_decode($response, true);
    if (!empty($data['locations'][0]['place']['address'])) {
        $location = $data['locations'][0]['place']['address'];
        $city = $location['addressLocality'] ?? '';
        $state = $location['addressAdministrativeArea'] ?? '';
    }
}

// --- 2. Fallback for India ---
if ($country === 'IN' && (!$city || !$state)) {
    $fallbackUrl = "http://www.postalpincode.in/api/pincode/$zip";
    $ch2 = curl_init();
    curl_setopt_array($ch2, [
        CURLOPT_URL => $fallbackUrl,
        CURLOPT_RETURNTRANSFER => true,
        CURLOPT_TIMEOUT => 5,
    ]);
    $fallbackResp = curl_exec($ch2);
    curl_close($ch2);

    $fData = json_decode($fallbackResp, true);
    if (!empty($fData['PostOffice'][0])) {
        if (!$city) $city = $fData['PostOffice'][0]['District'] ?? '';
        if (!$state) $state = $fData['PostOffice'][0]['State'] ?? '';
    }
}

// --- 3. Global fallback for other countries ---
if ((!$city || !$state) && $country !== 'IN') {
    $zpUrl = "https://api.zippopotam.us/$country/$zip";
    $zpResp = @file_get_contents($zpUrl);
    if ($zpResp) {
        $zpData = json_decode($zpResp, true);
        if (!$city) $city = $zpData['places'][0]['place name'] ?? '';
        if (!$state) $state = $zpData['places'][0]['state'] ?? '';
    }
}

// --- Return JSON ---
echo json_encode([
    'city' => $city ?? '',
    'state' => $state ?? ''
]);
