<?php
include '../db.php';
$conn->set_charset("utf8mb4");
session_start();

if(!isset($_SESSION['user_id'])){
    header('Location: login.php');
    exit;
}

$user = ['full_name' => 'User']; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $soft_copy_price = $conn->real_escape_string($_POST['soft_copy_price']);
    $hard_copy_price = $conn->real_escape_string($_POST['hard_copy_price']);
    $urgent_type_price = $conn->real_escape_string($_POST['urgent_type_price']);
    $weekend_type_price = $conn->real_escape_string($_POST['weekend_type_price']);
    $normal_type_price = $conn->real_escape_string($_POST['normal_type_price']);
    
    $driving_classes = [];
    if (isset($_POST['class_label']) && isset($_POST['class_price']) && is_array($_POST['class_label']) && is_array($_POST['class_price'])) {
        $labels = $_POST['class_label'];
        $prices = $_POST['class_price'];
        
        $count = min(count($labels), count($prices));

        for ($i = 0; $i < $count; $i++) {
            $label = trim($labels[$i]);
            $price = trim($prices[$i]);
            
            if (!empty($label)) {
                $driving_classes[] = [
                    'label' => $label,
                    'price' => $price
                ];
            }
        }
    }
    
    $driving_classes_json = $conn->real_escape_string(json_encode($driving_classes));

    $uploadDir = 'uploads/';
    $softCopyFileName = '';
    $hardCopyFileName = '';

    if (isset($_FILES['soft_copy_file']) && $_FILES['soft_copy_file']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['soft_copy_file']['name'], PATHINFO_EXTENSION);
        $softCopyFileName = uniqid('soft_') . '.' . $ext;
        move_uploaded_file($_FILES['soft_copy_file']['tmp_name'], $uploadDir . $softCopyFileName);
    }

    if (isset($_FILES['hard_copy_file']) && $_FILES['hard_copy_file']['error'] === UPLOAD_ERR_OK) {
        $ext = pathinfo($_FILES['hard_copy_file']['name'], PATHINFO_EXTENSION);
        $hardCopyFileName = uniqid('hard_') . '.' . $ext;
        move_uploaded_file($_FILES['hard_copy_file']['tmp_name'], $uploadDir . $hardCopyFileName);
    }

    $check_sql = "SELECT id FROM form_controll LIMIT 1";
    $check_result = $conn->query($check_sql);

    if ($check_result && $check_result->num_rows > 0) {
        $row = $check_result->fetch_assoc();
        $id = $row['id'];

        $update_fields = "
        soft_copy_price = '$soft_copy_price',
        hard_copy_price = '$hard_copy_price',
        urgent_type_price = '$urgent_type_price',
        weekend_type_price = '$weekend_type_price',
        normal_type_price = '$normal_type_price',
        driving_license_classes = '$driving_classes_json'
    ";

        if ($softCopyFileName !== '') {
            $update_fields .= ", soft_copy_file = '$softCopyFileName'";
        }

        if ($hardCopyFileName !== '') {
            $update_fields .= ", hard_copy_file = '$hardCopyFileName'";
        }

        $sql = "UPDATE form_controll SET $update_fields WHERE id = $id";
    } else {
        $columns = "soft_copy_price, hard_copy_price, urgent_type_price, weekend_type_price, normal_type_price, driving_license_classes";
        $values = "'$soft_copy_price', '$hard_copy_price', '$urgent_type_price', '$weekend_type_price', '$normal_type_price', '$driving_classes_json'";

        if ($softCopyFileName !== '') {
            $columns .= ", soft_copy_file";
            $values .= ", '$softCopyFileName'";
        }

        if ($hardCopyFileName !== '') {
            $columns .= ", hard_copy_file";
            $values .= ", '$hardCopyFileName'";
        }

        $sql = "INSERT INTO form_controll ($columns) VALUES ($values)";
    }

    if ($conn->query($sql) === TRUE) {
        $message = "Prices and image(s) saved successfully!";
    } else {
        $message = "Error saving data: " . $conn->error;
    }
}


$sql = "SELECT * FROM form_controll LIMIT 1";
$result = $conn->query($sql);
$driving_license_classes_data = [];

if ($result && $result->num_rows > 0) {
    $row = $result->fetch_assoc();
    if (!empty($row['driving_license_classes'])) {
        $decoded_classes = json_decode($row['driving_license_classes'], true);
        if (is_array($decoded_classes)) {
            $driving_license_classes_data = $decoded_classes;
        }
    }
} else {
    $row = [
        'soft_copy_price' => '',
        'hard_copy_price' => '',
        'urgent_type_price' => '',
        'weekend_type_price'  => '',
        'normal_type_price' => '',
    ];
}

if (empty($driving_license_classes_data)) {
     $driving_license_classes_data = [
        ['label' => 'A. Motorcycle (Dollar $)', 'price' => ''],
        ['label' => 'B. Passenger car (Dollar $)', 'price' => ''],
        ['label' => 'C. Vehicle over 7,000 Pound', 'price' => ''],
        ['label' => 'D. Vehicle over 10 seats', 'price' => ''],
        ['label' => 'E. B.C, or Class vehicle with trailer', 'price' => ''],
    ];
}
?>



<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Addon Options Dashboard</title>
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.6/dist/js/bootstrap.bundle.min.js"></script>
<link rel="stylesheet" href="assets/css/style.css">
<style>
    .circle-name { 
        width: 40px; height: 40px; 
        border-radius: 50%; background: #007bff; 
        color: #fff; text-align: center; line-height: 40px; 
        font-weight: bold; margin-right: 10px;
    }
    .table-style img { max-height: 50px; }
</style>
<script>
function generatePromo() {
    const chars = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
    let code = "";
    for (let i = 0; i < 8; i++) {
        code += chars.charAt(Math.floor(Math.random() * chars.length));
    }
    document.getElementById("promoInput").value = code;
}
</script>
</head>
<body>
<div class="dashboard_wrapper">
    <div class="left_panel">
        <div class="logo_box">
            <img src="../assets/images/logo.png" alt="logo" class="img-fluid full_logo">
            <img src="../assets/images/logo-icon.png" alt="logo" class="img-fluid logo_icon">
        </div>
         <?php include 'menu.php'; ?>
    </div>

    <div class="right_body_panel">
        <div class="right_header_panel">
            <div class="left_toggle_button">
                <button class="btn toggle_btn" type="button"></button>
            </div>
            <div class="right_user_box">
                <div class="user_box_warp">
                    <span class="circle-name"><?php echo strtoupper(substr($user['full_name'], 0, 2)); ?></span>
                    <div class="user_name"><h4><?php echo htmlspecialchars($user['full_name']); ?></h4></div>
                </div>
            </div>
        </div>

        <div class="body_wrapper_section p-3">
            <div class="body_wrap">
                <h3>Form Controller</h3>
                <div class=" inner-wrapper">
                    
                    <?php if (isset($message)) { ?>
                        <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
                    <?php } ?>
                
                    <form id='formControlForm' method="POST" enctype="multipart/form-data" class="form-wrapper">
                        <div class="row mb-3">
                            <div class="col-md-6"> 
                                <h4 class="form-heading">Soft Copy</h4>
                                <div class="upload_wrapper mb-2">
                                    <input type="file" name="soft_copy_file" class="form-control">
                                    <?php if (!empty($row['soft_copy_file'])): ?>
                                        <img src="uploads/<?= htmlspecialchars($row['soft_copy_file']) ?>" alt="Soft Copy" width="100">
                                    <?php else: ?>
                                        <img src="assets/images/placeholder.svg" alt="placeholder" class="img-fluid mt-2" width="100">
                                    <?php endif; ?>
                                </div>
                                <label for="soft_copy_price" class="form-label">Normal Price (Dollar $)</label>
                                <input type="text" id="soft_copy_price" name="soft_copy_price" placeholder="Enter soft copy price" class="form-control" value="<?php echo htmlspecialchars($row['soft_copy_price']); ?>" />
                            </div>

                            <div class="col-md-6"> 
                                <h4 class="form-heading">Hard Copy</h4>
                                <div class="upload_wrapper mb-2">
                                    <input type="file" name="hard_copy_file" class="form-control">
                                    <?php if (!empty($row['hard_copy_file'])): ?>
                                        <img src="uploads/<?php echo htmlspecialchars($row['hard_copy_file']); ?>" alt="Hard Copy" class="img-fluid mt-2" width="100">
                                    <?php else: ?>
                                        <img src="assets/images/placeholder.svg" alt="placeholder" class="img-fluid mt-2" width="100">
                                    <?php endif; ?>
                                </div>
                                <label for="hard_copy_price" class="form-label">Hard Copy Normal Price (Dollar $)</label>
                                <input type="text" id="hard_copy_price" name="hard_copy_price" placeholder="Enter hard copy price" class="form-control" value="<?php echo htmlspecialchars($row['hard_copy_price']); ?>" />
                            </div>
                        </div>

                        <div class="section mb-4 ">
                            <h4 class="form-heading">Type </h4>
                            <div>
                                <label for="urgent_type_price" class="form-label">Soft Copy Urgent (Dollar $) (Week Days)</label>
                                <input type="text" id="urgent_type_price" name="urgent_type_price" placeholder="Enter urgent type price" class="form-control" value="<?php echo htmlspecialchars($row['urgent_type_price']); ?>" />
                            </div>
                            <div>
                                <label for="weekend_type_price" class="form-label">Soft Copy Urgent Weekend (Dollar $)</label>
                                <input type="text" id="weekend_type_price" name="weekend_type_price" placeholder="Enter weekend type price" class="form-control" value="<?php echo htmlspecialchars($row['weekend_type_price']); ?>" />
                            </div>
                            <div>
                                <label for="normal_type_price" class="form-label">Hard Copy Urgent (Dollar $)</label>
                                <input type="text" id="normal_type_price" name="normal_type_price" placeholder="Enter normal type price" class="form-control" value="<?php echo htmlspecialchars($row['normal_type_price']); ?>" />
                            </div>
                        </div>
 
                        <div class="section mb-4">
                            <h4 class="form-heading">Classes of Driving License</h4>
                            <div id="license-classes-container">
                                <?php foreach ($driving_license_classes_data as $class): ?>
                                    <div class="row mb-2 license-class-row">
                                        <div class="col-md-6">
                                            <label class="form-label">Class Label</label>
                                            <input type="text" name="class_label[]" placeholder="Enter class label" class="form-control" value="<?php echo htmlspecialchars($class['label']); ?>" />
                                        </div>
                                        <div class="col-md-4">
                                            <label class="form-label">Price (Dollar $)</label>
                                            <input type="text" name="class_price[]" placeholder="Enter price" class="form-control" value="<?php echo htmlspecialchars($class['price']); ?>" />
                                        </div>
                                        <div class="col-md-2 d-flex align-items-end">
                                            <button type="button" class="btn btn-danger remove-class-btn">Remove</button>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                            <button type="button" id="add-class-btn" class="btn btn-secondary mt-2">Add Another Class</button>
                        </div>
                                     
                        <button type="submit" class="btn btn-primary">Save Prices</button>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const container = document.getElementById('license-classes-container');
    const addButton = document.getElementById('add-class-btn');

    addButton.addEventListener('click', function() {
        const newRow = document.createElement('div');
        newRow.className = 'row mb-2 license-class-row';
        newRow.innerHTML = `
            <div class="col-md-6">
                <label class="form-label">Class Label</label>
                <input type="text" name="class_label[]" placeholder="Enter class label" class="form-control" />
            </div>
            <div class="col-md-4">
                <label class="form-label">Price (Dollar $)</label>
                <input type="text" name="class_price[]" placeholder="Enter price" class="form-control" />
            </div>
            <div class="col-md-2 d-flex align-items-end">
                <button type="button" class="btn btn-danger remove-class-btn">Remove</button>
            </div>
        `;
        container.appendChild(newRow);
    });

    container.addEventListener('click', function(e) {
        if (e.target && e.target.classList.contains('remove-class-btn')) {
            const rowToRemove = e.target.closest('.license-class-row');
            if (rowToRemove) {
                rowToRemove.remove();
            }
        }
    });
});
</script>

</body>
</html>